/*
 * Decompiled with CFR 0.152.
 */
package game.engine.path;

import game.engine.BoundingBox;
import game.engine.path.AStarPathFinder;
import game.engine.path.Direction;
import game.engine.path.Edge;
import game.engine.path.Triangle;
import game.engine.path.Vertex;
import game.map.GameMap;
import game.map.MapPosition;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.newdawn.slick.Color;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.geom.Line;
import org.newdawn.slick.geom.Vector2f;
import org.poly2tri.Poly2Tri;
import org.poly2tri.geometry.polygon.Polygon;
import org.poly2tri.geometry.polygon.PolygonPoint;
import org.poly2tri.triangulation.TriangulationPoint;
import org.poly2tri.triangulation.delaunay.DelaunayTriangle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathFindingSystem {
    private static final float REDUCE_POINTS_EPSILON = 16.0f;
    private static final float MAX_POINT_DISTANCE = 256.0f;
    private GameMap map;
    private Triangle[] triangles;

    public PathFindingSystem(GameMap map) {
        this.map = map;
    }

    public void initialize() {
        MapPosition pos;
        boolean[][] blockMap = new boolean[this.map.getWidth()][this.map.getHeight()];
        for (int x = 0; x < this.map.getWidth(); ++x) {
            for (int y = 0; y < this.map.getHeight(); ++y) {
                blockMap[x][y] = this.map.isTileBlocked(x, y);
            }
        }
        ArrayList<Vector2f[]> paths = new ArrayList<Vector2f[]>();
        while ((pos = this.findBlockedEdgeTile(blockMap)) != null) {
            ArrayList<Direction> dirPath = this.tracePath(blockMap, pos);
            Vector2f[] points = this.generatePoints(pos, dirPath);
            points = this.reducePoints(points, 0, points.length, 16.0f);
            points = this.subdividePoints(points);
            paths.add(points);
            this.floodFill(blockMap, pos);
        }
        this.triangles = this.triangulate(paths);
    }

    private Triangle[] triangulate(ArrayList<Vector2f[]> paths) {
        List<DelaunayTriangle> externalTriangles = this.triangulateExternal(paths);
        ArrayList<Vertex> vertices = new ArrayList<Vertex>();
        ArrayList<Edge> edges = new ArrayList<Edge>();
        Triangle[] triangles = new Triangle[externalTriangles.size()];
        int triangleCount = 0;
        for (DelaunayTriangle externalTriangle : externalTriangles) {
            Triangle triangle;
            triangles[triangleCount] = triangle = new Triangle();
            ++triangleCount;
            int triangleVertexCount = 0;
            for (TriangulationPoint p : externalTriangle.points) {
                Vertex v = null;
                for (Vertex existing : vertices) {
                    if (!existing.equals(p.getXf(), p.getYf())) continue;
                    v = existing;
                }
                if (v == null) {
                    v = new Vertex(p.getXf(), p.getYf());
                    vertices.add(v);
                }
                triangle.vertices[triangleVertexCount] = v;
                v.owners.add(triangle);
                ++triangleVertexCount;
            }
            triangle.vertices[0].links.add(triangle.vertices[1]);
            triangle.vertices[1].links.add(triangle.vertices[0]);
            triangle.vertices[1].links.add(triangle.vertices[2]);
            triangle.vertices[2].links.add(triangle.vertices[1]);
            triangle.vertices[2].links.add(triangle.vertices[0]);
            triangle.vertices[0].links.add(triangle.vertices[2]);
            for (Edge e : edges) {
                if (e.equals(triangle.vertices[0], triangle.vertices[1])) {
                    triangle.edges[0] = e;
                    continue;
                }
                if (e.equals(triangle.vertices[1], triangle.vertices[2])) {
                    triangle.edges[1] = e;
                    continue;
                }
                if (!e.equals(triangle.vertices[2], triangle.vertices[0])) continue;
                triangle.edges[2] = e;
            }
            for (int i = 0; i < 3; ++i) {
                if (triangle.edges[i] == null) {
                    triangle.edges[i] = new Edge(triangle.vertices[i], triangle.vertices[(i + 1) % 3]);
                    edges.add(triangle.edges[i]);
                }
                triangle.edges[i].owners.add(triangle);
            }
        }
        return triangles;
    }

    private Vector2f[] subdividePoints(Vector2f[] points) {
        ArrayList<Vector2f> ret = new ArrayList<Vector2f>();
        Vector2f from = points[0];
        for (int i = 1; i <= points.length; ++i) {
            ret.add(from);
            Vector2f to = points[i % points.length];
            float distance = from.distance(to);
            if (distance > 256.0f) {
                int count = (int)(distance / 256.0f);
                float dx = (to.x - from.x) / (float)count;
                float dy = (to.y - from.y) / (float)count;
                for (int n = 1; n < count; ++n) {
                    Vector2f point = new Vector2f(from.x + (float)n * dx, from.y + (float)n * dy);
                    ret.add(point);
                }
            }
            from = to;
        }
        return ret.toArray(new Vector2f[0]);
    }

    private List<DelaunayTriangle> triangulateExternal(ArrayList<Vector2f[]> paths) {
        ArrayList<Polygon> polygons = new ArrayList<Polygon>();
        for (Vector2f[] path : paths) {
            PolygonPoint[] points = new PolygonPoint[path.length];
            for (int i = 0; i < path.length; ++i) {
                points[i] = new PolygonPoint(path[i].x, path[i].y);
            }
            polygons.add(new Polygon(points));
        }
        Polygon basePolygon = (Polygon)polygons.remove(0);
        for (Polygon hole : polygons) {
            basePolygon.addHole(hole);
        }
        Poly2Tri.triangulate(basePolygon);
        List<DelaunayTriangle> triangles = basePolygon.getTriangles();
        return triangles;
    }

    private Vector2f[] generatePoints(MapPosition pos, ArrayList<Direction> dirPath) {
        BoundingBox tile = this.map.getTileBounds();
        Vector2f point = new Vector2f((float)(pos.x + 1) * tile.getWidth(), (float)(pos.y + 1) * tile.getHeight());
        Vector2f[] points = new Vector2f[dirPath.size()];
        points[0] = new Vector2f(point);
        for (int i = 1; i <= dirPath.size() - 1; ++i) {
            Direction d = dirPath.get(i - 1);
            point.x += (float)d.x * tile.getWidth();
            point.y += (float)d.y * tile.getHeight();
            points[i] = new Vector2f(point);
        }
        return points;
    }

    private Vector2f[] reducePoints(Vector2f[] points, int from, int to, float epsilon) {
        float maxDistanceSquared = 0.0f;
        int maxIndex = from;
        Line line = new Line(points[from], points[to - 1]);
        for (int i = from + 1; i < to - 1; ++i) {
            float distanceSquared = line.distanceSquared(points[i]);
            if (!(distanceSquared > maxDistanceSquared)) continue;
            maxDistanceSquared = distanceSquared;
            maxIndex = i;
        }
        if (maxDistanceSquared > epsilon * epsilon) {
            int i;
            Vector2f[] firstSection = this.reducePoints(points, from, maxIndex + 1, epsilon);
            Vector2f[] secondSection = this.reducePoints(points, maxIndex, to, epsilon);
            Vector2f[] ret = new Vector2f[firstSection.length + secondSection.length - 1];
            for (i = 0; i < firstSection.length; ++i) {
                ret[i] = firstSection[i];
            }
            for (i = 1; i < secondSection.length; ++i) {
                ret[firstSection.length + i - 1] = secondSection[i];
            }
            return ret;
        }
        return new Vector2f[]{points[from], points[to - 1]};
    }

    private ArrayList<Direction> tracePath(boolean[][] blockMap, MapPosition start) {
        Direction dir;
        switch (this.evaluate(blockMap, start.x, start.y)) {
            case 0: {
                throw new IllegalArgumentException("Starting position not connected to any blocking tile.");
            }
            case 15: {
                throw new IllegalArgumentException("Starting position is inside blocking area.");
            }
        }
        ArrayList<Direction> directions = new ArrayList<Direction>();
        int x = start.x;
        int y = start.y;
        Direction prev = null;
        do {
            switch (this.evaluate(blockMap, x, y)) {
                case 1: {
                    dir = Direction.N;
                    break;
                }
                case 2: {
                    dir = Direction.E;
                    break;
                }
                case 3: {
                    dir = Direction.E;
                    break;
                }
                case 4: {
                    dir = Direction.W;
                    break;
                }
                case 5: {
                    dir = Direction.N;
                    break;
                }
                case 6: {
                    dir = prev == Direction.N ? Direction.W : Direction.E;
                    break;
                }
                case 7: {
                    dir = Direction.E;
                    break;
                }
                case 8: {
                    dir = Direction.S;
                    break;
                }
                case 9: {
                    dir = prev == Direction.E ? Direction.N : Direction.S;
                    break;
                }
                case 10: {
                    dir = Direction.S;
                    break;
                }
                case 11: {
                    dir = Direction.S;
                    break;
                }
                case 12: {
                    dir = Direction.W;
                    break;
                }
                case 13: {
                    dir = Direction.N;
                    break;
                }
                case 14: {
                    dir = Direction.W;
                    break;
                }
                case 0: {
                    throw new IllegalStateException("We somehow lost the path.");
                }
                case 15: {
                    throw new IllegalStateException("We somehow ended up inside the blocking area.");
                }
                default: {
                    throw new IllegalStateException("Unknown tile configuration.");
                }
            }
            directions.add(dir);
            prev = dir;
        } while ((x += dir.x) != start.x || (y += dir.y) != start.y);
        return directions;
    }

    private int evaluate(boolean[][] blockMap, int x, int y) {
        int ret = 0;
        if (this.blocked(blockMap, x, y)) {
            ret |= 1;
        }
        if (this.blocked(blockMap, x + 1, y)) {
            ret |= 2;
        }
        if (this.blocked(blockMap, x, y + 1)) {
            ret |= 4;
        }
        if (this.blocked(blockMap, x + 1, y + 1)) {
            ret |= 8;
        }
        return ret;
    }

    private boolean blocked(boolean[][] blockMap, int x, int y) {
        if (x < 0 || x >= blockMap.length) {
            return true;
        }
        if (y < 0 || y >= blockMap[0].length) {
            return true;
        }
        return blockMap[x][y];
    }

    private void floodFill(boolean[][] blockMap, MapPosition start) {
        LinkedList<MapPosition> queue = new LinkedList<MapPosition>();
        queue.push(start);
        while (!queue.isEmpty()) {
            MapPosition p = (MapPosition)queue.pop();
            blockMap[p.x][p.y] = false;
            for (int i = p.x - 1; i <= p.x + 1; ++i) {
                for (int j = p.y - 1; j <= p.y + 1; ++j) {
                    if (i == p.x && j == p.y || i < 0 || i >= blockMap.length || j < 0 || j >= blockMap[0].length || !blockMap[i][j]) continue;
                    queue.push(new MapPosition(i, j));
                }
            }
        }
    }

    private MapPosition findBlockedEdgeTile(boolean[][] blockMap) {
        for (int x = 0; x < this.map.getWidth(); ++x) {
            for (int y = 0; y < this.map.getHeight(); ++y) {
                if (!blockMap[x][y] || this.evaluate(blockMap, x, y) == 15) continue;
                return new MapPosition(x, y);
            }
        }
        return null;
    }

    public Vector2f[] findShotestPath(Vector2f from, Vector2f to) {
        return new AStarPathFinder(this.triangles).findPath(from, to);
    }

    public void debugRender(Graphics g) {
        g.setColor(Color.red);
        for (Triangle t : this.triangles) {
            Vertex[] vertices = t.vertices;
            Vertex from = vertices[0];
            for (int i = 1; i <= vertices.length; ++i) {
                Vertex to = vertices[i % vertices.length];
                g.fillOval(to.x - 2.0f, to.y - 2.0f, 4.0f, 4.0f);
                g.drawLine(from.x, from.y, to.x, to.y);
                from = to;
            }
        }
    }
}

