/*
 * Decompiled with CFR 0.152.
 */
package game.engine.path;

import game.engine.path.Triangle;
import game.engine.util.MathUtil;
import java.util.HashSet;
import java.util.Set;
import org.newdawn.slick.geom.Vector2f;

public class Vertex {
    private static final float EPSILON = 0.1f;
    public final float x;
    public final float y;
    public Set<Vertex> links = new HashSet<Vertex>();
    public Set<Triangle> owners = new HashSet<Triangle>();

    public Vertex(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public boolean equals(float x, float y) {
        return Math.abs(this.x - x) < 0.1f && Math.abs(this.y - y) < 0.1f;
    }

    public float distance(Vector2f v) {
        return this.distance(v.x, v.y);
    }

    public float distance(Vertex v) {
        return this.distance(v.x, v.y);
    }

    public float distance(float x, float y) {
        float dx = x - this.x;
        float dy = y - this.y;
        return MathUtil.sqrtf(dx * dx + dy * dy);
    }
}

