/*
 * Decompiled with CFR 0.152.
 */
package game.engine.spatial;

import game.engine.spatial.CircleShape;
import game.engine.spatial.SpatialObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.newdawn.slick.Color;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.geom.Vector2f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpatialQueryManager {
    private ArrayList<SpatialObject> objects = new ArrayList();
    private LinkedList<RayHit> debugRayHistory = new LinkedList();
    private boolean debug;

    public void add(SpatialObject object) {
        this.objects.add(object);
    }

    public void remove(SpatialObject object) {
        this.objects.remove(object);
    }

    public List<RayHit> rayCast(Vector2f from, Vector2f to) {
        boolean first = true;
        ArrayList<RayHit> hits = new ArrayList<RayHit>();
        for (SpatialObject o : this.objects) {
            float lambda = o.shape.rayTest(o.position, from, to);
            if (Float.isNaN(lambda)) continue;
            RayHit hit = new RayHit(from, to, lambda, o);
            if (first && this.debug) {
                this.debugRayHistory.addLast(new RayHit(from.copy(), to.copy(), lambda, o));
                if (this.debugRayHistory.size() > 1000) {
                    this.debugRayHistory.removeFirst();
                }
                first = false;
            }
            hits.add(hit);
        }
        if (first && this.debug) {
            this.debugRayHistory.addLast(new RayHit(from.copy(), to.copy(), 1.0f, null));
            if (this.debugRayHistory.size() > 1000) {
                this.debugRayHistory.removeFirst();
            }
            first = false;
        }
        Collections.sort(hits);
        return hits;
    }

    public List<SpatialObject> sphereQuery(Vector2f center, float radius) {
        return this.sphereQuery(center.x, center.y, radius);
    }

    public List<SpatialObject> sphereQuery(float x, float y, float radius) {
        ArrayList<SpatialObject> ret = new ArrayList<SpatialObject>();
        Vector2f p = new Vector2f(x, y);
        CircleShape c = new CircleShape(radius);
        for (SpatialObject o : this.objects) {
            if (!c.contains(p, o.shape, o.position)) continue;
            ret.add(o);
        }
        return ret;
    }

    public void setDebugEnabled(boolean debug) {
        if (debug != this.debug) {
            this.debugRayHistory.clear();
        }
        this.debug = debug;
    }

    public void debugRender(Graphics g) {
        for (SpatialObject o : this.objects) {
            g.setColor(Color.yellow);
            Vector2f p = o.position;
            o.shape.debugRender(g, p);
        }
        Vector2f temp = new Vector2f();
        for (RayHit hit : this.debugRayHistory) {
            hit.pos(temp);
            g.setColor(Color.green);
            g.drawLine(hit.from.x, hit.from.y, temp.x, temp.y);
            if (!(hit.lambda < 1.0f)) continue;
            g.setColor(Color.red);
            g.drawLine(temp.x, temp.y, hit.to.x, hit.to.y);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RayHit
    implements Comparable<RayHit> {
        public final Vector2f from;
        public final Vector2f to;
        public final float lambda;
        public final SpatialObject object;

        private RayHit(Vector2f from, Vector2f to, float lambda, SpatialObject object) {
            this.from = from;
            this.to = to;
            this.lambda = lambda;
            this.object = object;
        }

        public Vector2f pos() {
            Vector2f ret = new Vector2f();
            this.pos(ret);
            return ret;
        }

        public void pos(Vector2f out) {
            out.x = (1.0f - this.lambda) * this.from.x + this.lambda * this.to.x;
            out.y = (1.0f - this.lambda) * this.from.y + this.lambda * this.to.y;
        }

        @Override
        public int compareTo(RayHit o) {
            return Float.compare(this.lambda, o.lambda);
        }
    }
}

