/*
 * Decompiled with CFR 0.152.
 */
package game.engine.state;

import game.engine.state.State;
import game.world.GameWorld;
import java.util.EnumMap;
import org.newdawn.slick.GameContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StateMachine<StateList extends Enum<StateList>, StateType extends State> {
    private EnumMap<StateList, StateType> stateMap;
    private StateList currentState;

    public StateMachine(Class<StateList> stateListType) {
        this.stateMap = new EnumMap(stateListType);
        this.currentState = null;
    }

    public void put(StateList state, StateType object) {
        if (state == null) {
            throw new IllegalArgumentException("Cannot assign null state to state object.");
        }
        this.stateMap.put(state, object);
    }

    public void updateCurrentState(int dt, GameWorld world, GameContainer container) {
        ((State)this.stateMap.get(this.currentState)).update(dt, world, container);
    }

    public void transition(GameWorld world, StateList targetState) {
        if (targetState != this.currentState) {
            StateList previousState = this.currentState;
            this.currentState = targetState;
            if (previousState != null) {
                ((State)this.stateMap.get(previousState)).leave(world);
            }
            if (this.currentState != null) {
                ((State)this.stateMap.get(this.currentState)).enter(world);
            }
        }
    }

    public StateList getCurrentState() {
        return this.currentState;
    }

    public boolean is(StateList state) {
        return this.currentState == state;
    }

    public StateType getCurrentStateObject() {
        return (StateType)((State)this.stateMap.get(this.currentState));
    }

    public StateType getStateObject(StateList state) {
        return (StateType)((State)this.stateMap.get(state));
    }
}

