/*
 * Decompiled with CFR 0.152.
 */
package game.engine.util;

import org.newdawn.slick.Animation;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.state.GameState;
import org.newdawn.slick.state.StateBasedGame;
import org.newdawn.slick.state.transition.Transition;

public class AnimatedTransition
implements Transition {
    private Animation animation;
    private GameState from;
    private GameState to;

    public AnimatedTransition(Animation animation) {
        this.animation = animation.copy();
        this.animation.setLooping(false);
        this.animation.setAutoUpdate(false);
    }

    public void init(GameState firstState, GameState secondState) {
        this.animation.restart();
        this.animation.start();
        this.from = firstState;
        this.to = secondState;
    }

    public boolean isComplete() {
        return this.animation.isStopped();
    }

    public void postRender(StateBasedGame game, GameContainer container, Graphics g) throws SlickException {
        g.drawAnimation(this.animation, 0.0f, 0.0f);
    }

    public void preRender(StateBasedGame game, GameContainer container, Graphics g) throws SlickException {
        if (game.getCurrentStateID() == this.from.getID()) {
            this.from.render(container, game, g);
        } else {
            this.to.render(container, game, g);
        }
    }

    public void update(StateBasedGame game, GameContainer container, int dt) throws SlickException {
        this.animation.update(Math.min(100, dt));
    }
}

