/*
 * Decompiled with CFR 0.152.
 */
package game.engine.util;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import org.newdawn.slick.util.ResourceLocation;

public class CustomClasspathLocation
implements ResourceLocation {
    private ClassLoader loader;

    public CustomClasspathLocation() {
        this.loader = this.getClass().getClassLoader();
    }

    public CustomClasspathLocation(ClassLoader loader) {
        this.loader = loader;
    }

    public URL getResource(String ref) {
        return this.loader.getResource(this.simplifyPath(this.fixPath(ref)));
    }

    public InputStream getResourceAsStream(String ref) {
        InputStream ret = this.loader.getResourceAsStream(this.simplifyPath(this.fixPath(ref)));
        if (ret == null) {
            System.out.println("Failed to find resource " + ref + ".");
        }
        return ret;
    }

    private String fixPath(String ref) {
        return ref.replace('\\', '/');
    }

    private String simplifyPath(String path) {
        String[] components = path.split("/");
        ArrayList<String> simplified = new ArrayList<String>();
        for (String component : components) {
            if (component.equals(".")) continue;
            if (component.equals("..") && simplified.size() >= 1) {
                simplified.remove(simplified.size() - 1);
                continue;
            }
            simplified.add(component);
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < simplified.size(); ++i) {
            sb.append((String)simplified.get(i));
            if (i >= simplified.size() - 1) continue;
            sb.append("/");
        }
        return sb.toString();
    }
}

