/*
 * Decompiled with CFR 0.152.
 */
package game.engine.util;

import game.engine.util.LWJGLException;
import game.engine.util.OperatingSystem;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.EnumMap;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.newdawn.slick.util.ResourceLoader;

public class LWJGLInstaller {
    private EnumMap<OperatingSystem, String> archives;
    private File destination;

    public LWJGLInstaller(File destination) {
        this.destination = destination;
        this.archives = new EnumMap(OperatingSystem.class);
    }

    public void setOperatingSystemArchive(OperatingSystem os, String resourcePath) {
        this.archives.put(os, resourcePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File install(OperatingSystem os) throws LWJGLException {
        File osDestination = new File(this.destination.getAbsolutePath(), os.name());
        if (osDestination.exists() && osDestination.isDirectory() || osDestination.mkdirs()) {
            byte[] buffer = new byte[2048];
            String archive = this.archives.get((Object)os);
            try {
                InputStream ain = ResourceLoader.getResourceAsStream(archive);
                BufferedInputStream bin = new BufferedInputStream(ain);
                JarInputStream jin = new JarInputStream(bin);
                try {
                    JarEntry entry;
                    while ((entry = jin.getNextJarEntry()) != null) {
                        File file = new File(osDestination, entry.getName());
                        if (!file.exists()) {
                            int count;
                            FileOutputStream fout = new FileOutputStream(file);
                            while ((count = jin.read(buffer)) != -1) {
                                ((OutputStream)fout).write(buffer, 0, count);
                            }
                            jin.closeEntry();
                            ((OutputStream)fout).close();
                            continue;
                        }
                        if (file.isFile()) continue;
                        throw new LWJGLException("Cannot create native library file " + file + ".");
                    }
                }
                finally {
                    jin.close();
                }
                System.setProperty("org.lwjgl.librarypath", osDestination.getAbsolutePath());
                return osDestination;
            }
            catch (IOException e) {
                throw new LWJGLException("Failed to read the native library archive for your system.", e);
            }
        }
        throw new LWJGLException("Could not create destination folder for native libraries at " + osDestination + ".");
    }
}

