/*
 * Decompiled with CFR 0.152.
 */
package game.engine.util;

import org.newdawn.slick.geom.Vector2f;

public class MathUtil {
    public static final float SQRT_OF_TWO = 1.4142135f;

    public static float clamp(float x, float min, float max) {
        if (x < min) {
            return min;
        }
        if (x > max) {
            return max;
        }
        return x;
    }

    public static float absoluteMax(float x, float y) {
        if (Math.abs(x) < Math.abs(y)) {
            return y;
        }
        return x;
    }

    public static float absoluteMin(float x, float y) {
        if (Math.abs(x) < Math.abs(y)) {
            return x;
        }
        return y;
    }

    public static float sqrtf(float x) {
        return (float)Math.sqrt(x);
    }

    public static float wrap(float x, float min, float max) {
        x -= min;
        float diff = max - min;
        x = x < 0.0f ? diff + x % diff : (x %= diff);
        return x + min;
    }

    public static void rotateAroundPoint(Vector2f p, Vector2f center, float rotation) {
        p.sub(center);
        p.add(rotation);
        p.add(center);
    }

    public static float cos(float x) {
        return (float)Math.cos((double)x * Math.PI / 180.0);
    }
}

