/*
 * Decompiled with CFR 0.152.
 */
package game.entities;

import game.engine.BoundingBox;
import game.engine.loader.EntityDescriptor;
import game.entities.Entity;
import game.world.GameWorld;
import org.newdawn.slick.Animation;
import org.newdawn.slick.Color;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.geom.Vector2f;

public class GermBar
extends Entity {
    private float germLevel;
    private float hazmatLevel;

    public GermBar(EntityDescriptor descriptor) {
        super(descriptor);
        this.disableTransformedRendering();
    }

    public void updateGermLevel(float aGermLevel, float hazmatLevel) {
        this.germLevel = aGermLevel;
        this.hazmatLevel = hazmatLevel;
    }

    public void render(Graphics g, GameWorld world, GameContainer container) {
        Vector2f pos = world.getCamera().getScreenPos();
        BoundingBox box = world.getCamera().getScreenBounds();
        float x = pos.x - box.getWidth() / 2.0f;
        float y = pos.y - box.getHeight() / 2.0f;
        g.drawAnimation((Animation)this.animations.get("back"), x, y);
        float foregroundLength = 800.0f * (1.0f - this.germLevel);
        g.drawImage(((Animation)this.animations.get("front")).getCurrentFrame(), x, y, x + foregroundLength, y + 32.0f, 0.0f, 0.0f, foregroundLength, 32.0f, Color.white);
        foregroundLength = 800.0f * this.hazmatLevel;
        g.drawImage(((Animation)this.animations.get("hazmat")).getCurrentFrame(), x, y, x + foregroundLength, y + 32.0f, 0.0f, 0.0f, foregroundLength, 32.0f, Color.white);
    }
}

