/*
 * Decompiled with CFR 0.152.
 */
package game.entities;

import game.engine.loader.EntityDescriptor;
import game.entities.Player;
import game.entities.Toilet;
import game.map.MapObjectData;
import game.world.GameWorld;
import game.world.LDGameWorld;

public class GoldenToilet
extends Toilet {
    private String level;
    private boolean hasTriggeredCleaning = false;

    public void setMapData(MapObjectData data) {
        super.setMapData(data);
        this.level = data.getProperty("level", null);
    }

    public GoldenToilet(EntityDescriptor descriptor) {
        super(descriptor);
        this.isGoldenToilet = true;
    }

    protected boolean onUseToilet(Player player, GameWorld world) {
        if (this.hasTriggeredCleaning) {
            LDGameWorld ldWorld = (LDGameWorld)world;
            if (this.level == null) {
                ldWorld.winGame();
            } else {
                ldWorld.transitionToLevel(this.level);
            }
        } else {
            LDGameWorld ldWorld = (LDGameWorld)world;
            ldWorld.setIsWashingHands(true, true);
            this.hasTriggeredCleaning = true;
        }
        return true;
    }
}

