/*
 * Decompiled with CFR 0.152.
 */
package game.entities;

import game.engine.BoundingBox;
import game.engine.loader.EntityDescriptor;
import game.entities.Entity;
import game.entities.HandGerm;
import game.world.GameWorld;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import org.newdawn.slick.Animation;
import org.newdawn.slick.Color;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.geom.Vector2f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Hand
extends Entity {
    static final float BUTTON_IMPULSE = 4.0f;
    private boolean isLeftHand;
    private Vector2f momentum;
    private BoundingBox[] germAreas;
    private List<HandGerm> germs;

    public Hand(EntityDescriptor descriptor) {
        super(descriptor);
        this.isLeftHand = descriptor.properties.getBoolean("is_left");
        this.momentum = new Vector2f();
        this.germAreas = new BoundingBox[4];
        for (int i = 0; i < 4; ++i) {
            this.germAreas[i] = (BoundingBox)this.boundingBoxes.get("germ_bounds" + i);
        }
        this.germs = new LinkedList<HandGerm>();
    }

    @Override
    public void update(int dt, GameWorld world, GameContainer container) {
        if (!this.isLeftHand) {
            if (container.getInput().isKeyDown(200)) {
                this.momentum.y -= 4.0f;
            }
            if (container.getInput().isKeyDown(208)) {
                this.momentum.y += 4.0f;
            }
            if (container.getInput().isKeyDown(203)) {
                this.momentum.x -= 4.0f;
            }
            if (container.getInput().isKeyDown(205)) {
                this.momentum.x += 4.0f;
            }
        } else {
            if (container.getInput().isKeyDown(17)) {
                this.momentum.y -= 4.0f;
            }
            if (container.getInput().isKeyDown(31)) {
                this.momentum.y += 4.0f;
            }
            if (container.getInput().isKeyDown(30)) {
                this.momentum.x -= 4.0f;
            }
            if (container.getInput().isKeyDown(32)) {
                this.momentum.x += 4.0f;
            }
        }
        Vector2f currPos = this.getPos();
        Vector2f nextPos = currPos.copy().add(this.momentum.copy().scale((float)dt / 1000.0f));
        if (nextPos.y < -280.0f) {
            nextPos.y = -280.0f;
            this.momentum.y = 0.0f;
        } else if (nextPos.y > 0.0f) {
            nextPos.y = 0.0f;
            this.momentum.y = 0.0f;
        }
        if (nextPos.x > 240.0f) {
            nextPos.x = 240.0f;
            this.momentum.x = 0.0f;
        } else if (nextPos.x < -770.0f) {
            nextPos.x = -770.0f;
            this.momentum.x = 0.0f;
        }
        nextPos = currPos.copy().add(this.momentum.copy().scale((float)dt / 1000.0f));
        Vector2f translation = nextPos.sub(currPos);
        this.translate(translation);
        for (HandGerm germ : this.germs) {
            germ.translate(translation);
        }
    }

    @Override
    public void debugRender(Graphics g, GameWorld world, GameContainer container) {
        super.debugRender(g, world, container);
        for (int i = 0; i < 4; ++i) {
            g.pushTransform();
            BoundingBox germArea = this.germAreas[i];
            g.setColor(new Color(0.0f, 0.0f, 1.0f, 0.3f));
            g.fillRect(germArea.getMinX(this.getPos()), germArea.getMinY(this.getPos()), germArea.getWidth(), germArea.getHeight());
            g.setColor(Color.blue);
            g.drawRect(germArea.getMinX(this.getPos()), germArea.getMinY(this.getPos()), germArea.getWidth(), germArea.getHeight());
            g.popTransform();
        }
    }

    @Override
    public void render(Graphics g, GameWorld world, GameContainer container) {
        super.render(g, world, container);
        Animation animation = this.isLeftHand ? (Animation)this.animations.get("left_hand") : (Animation)this.animations.get("right_hand");
        g.pushTransform();
        g.drawAnimation(animation, 0.0f, 0.0f);
        g.popTransform();
    }

    @Override
    public BoundingBox getBounds() {
        return (BoundingBox)this.boundingBoxes.get("bounds");
    }

    public Vector2f generateGermPosition(Random random) {
        BoundingBox germBB = (BoundingBox)this.boundingBoxes.get("germ");
        BoundingBox handBB = this.germAreas[random.nextInt(4)];
        float offsetX = random.nextFloat() * (handBB.getWidth() - germBB.getWidth());
        float offsetY = random.nextFloat() * (handBB.getHeight() - germBB.getHeight());
        return new Vector2f(handBB.getMinX(this.getPos()) + offsetX, handBB.getMinY(this.getPos()) + offsetY);
    }

    public void attachGerm(HandGerm germ) {
        germ.setHitPoints(700);
        this.germs.add(germ);
    }

    public List<HandGerm> getGerms() {
        return this.germs;
    }

    public void clearGerms() {
        for (HandGerm germ : this.germs) {
            germ.setHitPoints(-1);
        }
        this.germs.clear();
    }
}

