/*
 * Decompiled with CFR 0.152.
 */
package game.entities;

import game.engine.loader.EntityDescriptor;
import game.entities.Entity;
import game.world.GameWorld;
import java.util.Random;
import org.newdawn.slick.Animation;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;

public class HandGerm
extends Entity {
    private int hitPoints;
    Animation germ_animation;

    public HandGerm(EntityDescriptor descriptor) {
        super(descriptor);
    }

    public void render(Graphics g, GameWorld world, GameContainer container) {
        super.render(g, world, container);
        if (this.hitPoints > 0) {
            g.pushTransform();
            g.drawAnimation(this.germ_animation, 0.0f, 0.0f);
            g.popTransform();
        }
    }

    public void changeAnimation(Random random) {
        this.germ_animation = (Animation)this.animations.get("germ" + random.nextInt(10));
    }

    public boolean doDamage(int damage) {
        this.hitPoints -= damage;
        return this.hitPoints <= 0;
    }

    public void setHitPoints(int hitPoints) {
        this.hitPoints = hitPoints;
    }
}

