/*
 * Decompiled with CFR 0.152.
 */
package game.entities;

import game.engine.BoundingBox;
import game.engine.loader.EntityDescriptor;
import game.entities.Entity;
import game.entities.Player;
import game.world.GameWorld;
import game.world.MapGameWorld;
import org.newdawn.slick.Color;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.geom.Vector2f;

public class MapLayer
extends Entity {
    private String[] layers;
    private int[] layerIds;
    private boolean autoHide;

    public MapLayer(EntityDescriptor descriptor) {
        super(descriptor);
        this.disableTransformedRendering();
        this.enableCustomRendering();
        this.layers = descriptor.properties.getArray("layers", new String[0]);
        this.autoHide = descriptor.properties.getBoolean("autohide", false);
    }

    public void debugRender(Graphics g, GameWorld world, GameContainer container) {
        super.debugRender(g, world, container);
        MapGameWorld mapWorld = (MapGameWorld)world;
        BoundingBox screenBounds = world.getCamera().getScreenBounds();
        Vector2f screenPos = world.getCamera().getScreenPos();
        for (int id : this.layerIds) {
            if (mapWorld.getDebugMapLayerId() != id) continue;
            mapWorld.getMap().debugRenderLayer(g, id, screenBounds, screenPos, Color.red);
        }
    }

    public void init(GameWorld world) {
        super.init(world);
        MapGameWorld mapWorld = (MapGameWorld)world;
        this.layerIds = new int[this.layers.length];
        for (int i = 0; i < this.layers.length; ++i) {
            this.layerIds[i] = mapWorld.getMap().getLayerId(this.layers[i]);
            if (this.layerIds[i] != -1) continue;
            throw new RuntimeException("Map layer \"" + this.layers[i] + "\" could not be found in map.");
        }
    }

    public void render(Graphics g, GameWorld world, GameContainer container) {
        MapGameWorld mapWorld = (MapGameWorld)world;
        BoundingBox screenBounds = world.getCamera().getScreenBounds();
        Vector2f screenPos = world.getCamera().getScreenPos();
        boolean render = true;
        Player player = world.getEntities().getOne(Player.class);
        if (this.autoHide && player != null) {
            for (int id : this.layerIds) {
                if (!mapWorld.getMap().isLayerBlocked(id, player.getCollisionBox(), player.getPos())) continue;
                render = false;
            }
        }
        if (render) {
            for (int id : this.layerIds) {
                mapWorld.getMap().renderLayer(g, id, screenBounds, screenPos);
            }
        }
    }
}

