/*
 * Decompiled with CFR 0.152.
 */
package game.entities;

import game.engine.BoundingBox;
import game.engine.KeepInViewCamera;
import game.engine.loader.EntityDescriptor;
import game.engine.util.MathUtil;
import game.entities.Entity;
import game.world.GameWorld;
import java.util.ArrayList;
import org.newdawn.slick.Animation;
import org.newdawn.slick.Color;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.Image;
import org.newdawn.slick.geom.Vector2f;

public class ParallaxBackground
extends Entity {
    private ArrayList<Layer> layers;

    public ParallaxBackground(EntityDescriptor descriptor) {
        super(descriptor);
        this.enableCustomRendering();
        this.disableTransformedRendering();
        this.layers = new ArrayList();
        String[] layerAnimations = this.properties.getArray("layers", "default");
        float[] layerMovementFactors = this.properties.getFloatArray("movement_factors", 0.0f);
        if (layerMovementFactors.length < layerAnimations.length * 2) {
            throw new RuntimeException("Not enough movement factors for parallax background.");
        }
        for (int i = 0; i < layerAnimations.length; ++i) {
            this.layers.add(new Layer((Animation)this.animations.get(layerAnimations[i]), layerMovementFactors[2 * i + 0], layerMovementFactors[2 * i + 1]));
        }
    }

    public void render(Graphics g, GameWorld world, GameContainer container) {
        super.render(g, world, container);
        KeepInViewCamera camera = world.getCamera();
        BoundingBox bounds = camera.getScreenBounds();
        Vector2f pos = camera.getScreenPos();
        for (Layer l : this.layers) {
            l.render(g, bounds, pos);
        }
    }

    public void debugRender(Graphics g, GameWorld world, GameContainer container) {
        super.debugRender(g, world, container);
        KeepInViewCamera camera = world.getCamera();
        BoundingBox bounds = camera.getScreenBounds();
        Vector2f pos = camera.getScreenPos();
        for (Layer l : this.layers) {
            l.debugRender(g, bounds, pos);
        }
    }

    private static class Layer {
        private final Animation animation;
        private final float xFactor;
        private final float yFactor;

        public Layer(Animation animation, float xFactor, float yFactor) {
            this.animation = animation;
            this.xFactor = xFactor;
            this.yFactor = yFactor;
        }

        public void render(Graphics g, BoundingBox bounds, Vector2f pos) {
            float w = this.animation.getWidth();
            float h = this.animation.getHeight();
            float minX = bounds.getMinX(pos);
            float minY = bounds.getMinY(pos);
            float maxX = bounds.getMaxX(pos);
            float maxY = bounds.getMaxY(pos);
            minX -= MathUtil.wrap(minX * this.xFactor, 0.0f, w);
            minY -= MathUtil.wrap(minY * this.yFactor, 0.0f, h);
            Image frame = this.animation.getCurrentFrame();
            frame.startUse();
            for (float y = minY; y < maxY; y += h) {
                for (float x = minX; x < maxX; x += w) {
                    frame.drawEmbedded(x, y, w, h);
                }
            }
            frame.endUse();
        }

        public void debugRender(Graphics g, BoundingBox bounds, Vector2f pos) {
            float w = this.animation.getWidth();
            float h = this.animation.getHeight();
            float minX = bounds.getMinX(pos);
            float minY = bounds.getMinY(pos);
            float maxX = bounds.getMaxX(pos);
            float maxY = bounds.getMaxY(pos);
            minX -= MathUtil.wrap(minX * this.xFactor, 0.0f, w);
            minY -= MathUtil.wrap(minY * this.yFactor, 0.0f, h);
            g.setColor(Color.gray);
            for (float y = minY; y < maxY; y += h) {
                for (float x = minX; x < maxX; x += w) {
                    g.drawRect(x, y, w, h);
                }
            }
        }
    }
}

