/*
 * Decompiled with CFR 0.152.
 */
package game.entities;

import game.engine.BoundingBox;
import game.engine.loader.EntityDescriptor;
import game.entities.Entity;
import game.entities.Player;
import game.world.GameWorld;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.geom.Vector2f;

public abstract class Pickupable
extends Entity {
    public Pickupable(EntityDescriptor descriptor) {
        super(descriptor);
    }

    public void update(int dt, GameWorld world, GameContainer container) {
        Vector2f playerPos;
        BoundingBox playerBounds;
        Vector2f pos;
        BoundingBox bounds;
        super.update(dt, world, container);
        Player player = world.getEntities().getOne(Player.class);
        if (player != null && (bounds = this.getBounds()).intersects(pos = this.getPos(), playerBounds = player.getCollisionBox(), playerPos = player.getPos()) && this.onPickup(world, player)) {
            String textEntity = (String)this.properties.get("textentity");
            if (textEntity != null) {
                Entity entity = (Entity)world.getLoader().create(textEntity);
                entity.setPos(this.getPos());
                world.getEntities().add(entity);
            }
            world.getEntities().remove(this);
        }
    }

    protected abstract boolean onPickup(GameWorld var1, Player var2);
}

