/*
 * Decompiled with CFR 0.152.
 */
package game.entities;

import game.engine.BoundingBox;
import game.engine.loader.EntityDescriptor;
import game.engine.state.AbstractState;
import game.engine.state.State;
import game.engine.state.StateMachine;
import game.entities.Character;
import game.entities.Enemy;
import game.entities.Entity;
import game.entities.GermBar;
import game.world.GameWorld;
import game.world.MapGameWorld;
import java.util.ArrayList;
import java.util.Iterator;
import org.newdawn.slick.Animation;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.geom.Vector2f;

public class Player
extends Character {
    private static final float ILDE_GERMINATION_RATE = 0.01f;
    private StateMachine<PlayerState, State> states;
    private ArrayList<Enemy> interactingEnemies;
    private Direction direction;
    private boolean walking;
    private BoundingBox collisionBox;
    private float germLevel;
    private GermBar germBar;
    private float walkSpeed;
    private int hazmatDuration;
    private int initialHazmatDuration;

    public Player(EntityDescriptor descriptor) {
        super(descriptor);
        if (descriptor.boundingBoxes.contains("collision")) {
            this.collisionBox = descriptor.boundingBoxes.get("collision");
        }
        this.direction = Direction.left;
        this.walking = false;
        this.states = new StateMachine(PlayerState.class);
        this.states.put(PlayerState.standard, new StandardState());
        this.states.put(PlayerState.interacting, new InteractingState());
        this.interactingEnemies = new ArrayList();
        this.walkSpeed = this.properties.getFloat("walk_speed", 300.0f);
        this.germLevel = 0.0f;
        this.hazmatDuration = 0;
        this.initialHazmatDuration = 0;
    }

    public void update(int dt, GameWorld world, GameContainer container) {
        if (this.states.is(null)) {
            this.states.transition(world, PlayerState.standard);
        }
        this.states.updateCurrentState(dt, world, container);
        this.hazmatDuration -= dt;
        if (this.hazmatDuration > 0) {
            this.germLevel += 0.01f * this.germLevel * (float)dt / 1000.0f;
        }
        this.germBar.updateGermLevel(this.germLevel, (float)this.hazmatDuration / (float)Math.max(1, this.initialHazmatDuration));
        if (this.germLevel > 1.0f) {
            world.triggerGameOver();
        }
    }

    public void render(Graphics g, GameWorld world, GameContainer container) {
        super.render(g, world, container);
        String prefix = this.hazmatDuration > 0 ? "hazmat" : "player";
        Animation animation = (Animation)this.animations.get(prefix + "Idle");
        if (this.states.is(PlayerState.standard) && this.walking) {
            animation = (Animation)this.animations.get(prefix + "Walking");
        } else if (this.states.is(PlayerState.interacting)) {
            animation = (Animation)this.animations.get(prefix + "HandShake");
        }
        g.pushTransform();
        g.scale(this.direction.scale, 1.0f);
        float x = 0.5f * (this.direction.scale - 1.0f) * (float)animation.getWidth();
        g.drawAnimation(animation, x, 0.0f);
        g.popTransform();
    }

    public void onStartInteracting(GameWorld world, Enemy enemy) {
        this.states.transition(world, PlayerState.interacting);
        this.interactingEnemies.add(enemy);
        this.direction = enemy.getPos().x - this.getPos().x > 0.0f ? Direction.right : Direction.left;
    }

    public void onStopInteracting(GameWorld world, Enemy enemy) {
        boolean removed = this.interactingEnemies.remove(enemy);
        if (removed && this.interactingEnemies.size() == 0) {
            this.states.transition(world, PlayerState.standard);
        }
    }

    public void setGermBar(GermBar germBar) {
        this.germBar = germBar;
    }

    public float getGermLevel() {
        return this.germLevel;
    }

    public void setGermLevel(float germLevel) {
        this.germLevel = germLevel;
    }

    public boolean isShakingHands() {
        return !this.interactingEnemies.isEmpty();
    }

    public void enableHazmatMode(int duration) {
        this.initialHazmatDuration = duration;
        this.hazmatDuration = duration;
    }

    public boolean isHazmatMode() {
        return this.hazmatDuration > 0;
    }

    private class StandardState
    extends AbstractState {
        private StandardState() {
        }

        public void update(int dt, GameWorld world, GameContainer container) {
            Vector2f move = new Vector2f(0.0f, 0.0f);
            if (container.getInput().isKeyDown(200)) {
                move.y -= 1.0f;
            }
            if (container.getInput().isKeyDown(208)) {
                move.y += 1.0f;
            }
            if (container.getInput().isKeyDown(203)) {
                move.x -= 1.0f;
            }
            if (container.getInput().isKeyDown(205)) {
                move.x += 1.0f;
            }
            if (move.lengthSquared() > 1.0f) {
                move.scale(0.70710677f);
            }
            move.scale((float)dt * Player.this.walkSpeed / 1000.0f);
            if (move.length() > 0.0f) {
                Player.this.walking = true;
                if (move.x < 0.0f) {
                    Player.this.direction = Direction.left;
                } else if (move.x > 0.0f) {
                    Player.this.direction = Direction.right;
                }
            } else {
                Player.this.walking = false;
            }
            if (!((MapGameWorld)world).collisionCheck(Player.this.getPos().copy().add(move), Player.this.collisionBox)) {
                Player.this.translate(move);
            } else if (move.x != 0.0f && !((MapGameWorld)world).collisionCheck(Player.this.getPos().copy().add(new Vector2f(move.x, 0.0f)), Player.this.collisionBox)) {
                move.y = 0.0f;
                Player.this.translate(move);
            } else if (move.y != 0.0f && !((MapGameWorld)world).collisionCheck(Player.this.getPos().copy().add(new Vector2f(0.0f, move.y)), Player.this.collisionBox)) {
                move.x = 0.0f;
                Player.this.translate(move);
            } else {
                Player.this.walking = false;
            }
        }
    }

    private class InteractingState
    extends AbstractState {
        private static final int CLICK_COUNT = 4;
        private static final float GERMENATING_SPEED = 0.05f;
        private static final float KNOCKBACK_RADIUS = 100.0f;
        private int clickCounter = 0;

        public void enter(GameWorld world) {
            this.clickCounter = 0;
        }

        public void leave(GameWorld world) {
            for (Enemy enemy : new ArrayList(Player.this.interactingEnemies)) {
                enemy.onStopInteracting(world);
            }
            Player.this.interactingEnemies.clear();
        }

        public void update(int dt, GameWorld world, GameContainer container) {
            if (!Player.this.isHazmatMode()) {
                Player.this.germLevel += (float)Math.min(3, Player.this.interactingEnemies.size()) * 0.05f * (float)dt / 1000.0f;
            }
            if (container.getInput().isKeyPressed(57)) {
                ++this.clickCounter;
            }
            if (this.clickCounter >= 4) {
                Iterator i$ = world.getEntities().get((Entity)((Object)Enemy.class)).iterator();
                while (i$.hasNext()) {
                    Enemy enemy = (Enemy)i$.next();
                    if (!(Player.this.getPos().distanceSquared(enemy.getPos()) <= 10000.0f)) continue;
                    enemy.knockBack(world);
                }
                Player.this.states.transition(world, PlayerState.standard);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum PlayerState {
        standard,
        interacting;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Direction {
        left(-1.0f),
        right(1.0f);

        public final float scale;

        private Direction(float scale) {
            this.scale = scale;
        }
    }
}

