/*
 * Decompiled with CFR 0.152.
 */
package game.entities;

import game.engine.BaseEntity;
import game.engine.BoundingBox;
import game.engine.loader.AssetEntry;
import game.engine.loader.EntityDescriptor;
import game.entities.Entity;
import game.world.GameWorld;
import org.newdawn.slick.Animation;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.Image;
import org.newdawn.slick.geom.Vector2f;
import org.newdawn.slick.openal.Audio;

public class SpeechBubble
extends Entity {
    private static final int SOUND_COOLDOWN = 500;
    private int duration;
    private int age = 0;
    private int frameIndex = 0;
    private boolean centered;
    private Audio[] soundArray;
    private static int lastSpeechSoundTime = 0;

    public SpeechBubble(EntityDescriptor descriptor) {
        super(descriptor);
        this.enableCustomRendering();
        this.duration = this.properties.getInt("duration", 2000);
        this.centered = this.properties.getBoolean("centered", false);
        this.soundArray = new Audio[this.sounds.size()];
        int i = 0;
        for (AssetEntry a : this.sounds) {
            this.soundArray[i] = (Audio)a.asset;
            ++i;
        }
        if (this.centered) {
            this.disableTransformedRendering();
            this.enableCustomRendering();
        }
    }

    public void init(GameWorld world) {
        super.init(world);
        Animation animation = (Animation)this.animations.get("default");
        this.frameIndex = world.getRandom().nextInt(animation.getFrameCount());
        int currentTime = world.getElapsedTime();
        if (this.soundArray.length != 0 && currentTime - lastSpeechSoundTime >= 500) {
            int soundIndex = world.getRandom().nextInt(this.soundArray.length);
            this.soundArray[soundIndex].playAsSoundEffect(1.0f, 1.0f, false);
            lastSpeechSoundTime = currentTime;
        }
    }

    public void render(Graphics g, GameWorld world, GameContainer container) {
        super.render(g, world, container);
        Animation animation = (Animation)this.animations.get("default");
        Image image = animation.getImage(this.frameIndex);
        if (this.centered) {
            Vector2f pos = world.getCamera().getScreenPos();
            BoundingBox box = world.getCamera().getScreenBounds();
            float x = box.getCenterX(pos) - (float)image.getWidth() / 2.0f;
            float y = box.getCenterY(pos) - (float)image.getHeight() / 2.0f;
            g.drawImage(image, x, y);
        } else {
            g.drawImage(image, 0.0f, 0.0f);
        }
    }

    public void update(int dt, GameWorld world, GameContainer container) {
        super.update(dt, world, container);
        this.age += dt;
        if (this.age > this.duration) {
            world.getEntities().remove(this);
        }
    }

    public void positionAbove(BaseEntity entity) {
        Vector2f pos = entity.getPos();
        float x = pos.x;
        float y = pos.y;
        BoundingBox bb = entity.getBounds();
        if (bb != null) {
            x += bb.getCenterX(0.0f, 0.0f);
            y += bb.getMinX(0.0f, 0.0f);
        }
        bb = this.getBounds();
        this.setPos(x -= bb.getCenterX(0.0f, 0.0f), y -= bb.getMaxY(0.0f, 0.0f));
    }
}

