/*
 * Decompiled with CFR 0.152.
 */
package game.entities;

import game.engine.loader.EntityDescriptor;
import game.entities.Entity;
import game.world.GameWorld;
import java.util.Random;
import org.newdawn.slick.Animation;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;

public class StaticImage
extends Entity {
    private int displayDuration;
    private float maxRotation;
    private float rotationSpeed;
    private float currentAngle;
    private boolean rotatingForward;
    private float maxShakeDistanceX;
    private float maxShakeDistanceY;
    private int shakeDuration;

    public StaticImage(EntityDescriptor descriptor) {
        super(descriptor);
        this.displayDuration = this.properties.getInt("display_duration", Integer.MAX_VALUE);
        this.maxRotation = this.properties.getFloat("max_rotation", 0.0f);
        this.rotationSpeed = this.properties.getFloat("rotation_speed", 0.0f);
        this.currentAngle = 0.0f;
        this.rotatingForward = true;
        this.maxShakeDistanceX = this.properties.getFloat("max_shake_distance_x", 0.0f);
        this.maxShakeDistanceY = this.properties.getFloat("max_shake_distance_y", 0.0f);
        this.shakeDuration = this.properties.getInt("shake_duration", 0);
    }

    public void render(Graphics g, GameWorld world, GameContainer container) {
        super.render(g, world, container);
        Animation animation = (Animation)this.animations.get("static_image");
        if (this.displayDuration > 0) {
            g.pushTransform();
            g.rotate((float)animation.getWidth() / 2.0f, (float)animation.getHeight() / 2.0f, this.currentAngle);
            if (this.shakeDuration > 0) {
                Random rng = world.getRandom();
                float shakeX = (2.0f * rng.nextFloat() - 1.0f) * this.maxShakeDistanceX;
                float shakeY = (2.0f * rng.nextFloat() - 1.0f) * this.maxShakeDistanceY;
                g.translate(shakeX, shakeY);
            }
            g.drawAnimation(animation, 0.0f, 0.0f);
            g.popTransform();
        }
    }

    public void update(int dt, GameWorld world, GameContainer container) {
        super.update(dt, world, container);
        if (Math.abs(this.currentAngle) > this.maxRotation) {
            this.currentAngle = (this.rotatingForward ? 1.0f : -1.0f) * this.maxRotation;
            this.rotatingForward = !this.rotatingForward;
        }
        this.currentAngle += (this.rotatingForward ? 1.0f : -1.0f) * this.rotationSpeed * ((float)dt / 1000.0f);
        this.shakeDuration -= dt;
        this.displayDuration -= dt;
    }

    public void setShake(int shakeDuration, float maxShakeDistanceX, float maxShakeDistanceY) {
        this.shakeDuration = shakeDuration;
        this.maxShakeDistanceX = maxShakeDistanceX;
        this.maxShakeDistanceY = maxShakeDistanceY;
    }
}

