/*
 * Decompiled with CFR 0.152.
 */
package game.entities;

import game.engine.BoundingBox;
import game.engine.loader.EntityDescriptor;
import game.entities.Entity;
import game.entities.Player;
import game.map.MapObject;
import game.map.MapObjectData;
import game.world.GameWorld;
import game.world.LDGameWorld;
import org.newdawn.slick.Animation;
import org.newdawn.slick.Color;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.geom.Vector2f;

public class Toilet
extends Entity
implements MapObject {
    private State state;
    protected boolean isGoldenToilet;

    public Toilet(EntityDescriptor descriptor) {
        super(descriptor);
        this.enableCustomRendering();
        this.state = State.enabled;
        this.isGoldenToilet = false;
    }

    public void setMapData(MapObjectData data) {
    }

    public void update(int dt, GameWorld world, GameContainer container) {
        super.update(dt, world, container);
        Player player = world.getEntities().getOne(Player.class);
        if (player != null && this.state == State.enabled) {
            BoundingBox collisionBox = player.getCollisionBox();
            Vector2f playerPos = player.getPos();
            BoundingBox entryBox = (BoundingBox)this.boundingBoxes.get("entry");
            Vector2f pos = this.getPos();
            if (entryBox != null && entryBox.contains(pos, collisionBox, playerPos) && this.onUseToilet(player, world) && !this.isGoldenToilet) {
                this.state = State.disabled;
            }
        }
    }

    protected boolean onUseToilet(Player player, GameWorld world) {
        LDGameWorld ldWorld = (LDGameWorld)world;
        ldWorld.setIsWashingHands(true, false);
        return true;
    }

    public void render(Graphics g, GameWorld world, GameContainer container) {
        super.render(g, world, container);
        Animation animation = (Animation)this.animations.get(this.state.animation);
        if (animation != null) {
            g.drawAnimation(animation, 0.0f, 0.0f);
        }
    }

    public void debugRender(Graphics g, GameWorld world, GameContainer container) {
        super.debugRender(g, world, container);
        Vector2f pos = this.getPos();
        BoundingBox entryBox = (BoundingBox)this.boundingBoxes.get("entry");
        if (entryBox != null) {
            g.setColor(new Color(1.0f, 0.0f, 0.0f, 0.3f));
            g.fillRect(entryBox.getMinX(pos), entryBox.getMinY(pos), entryBox.getWidth(), entryBox.getHeight());
            g.setColor(Color.red);
            g.drawRect(entryBox.getMinX(pos), entryBox.getMinY(pos), entryBox.getWidth(), entryBox.getHeight());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        enabled("default"),
        disabled("disabled");

        private final String animation;

        private State(String animation) {
            this.animation = animation;
        }
    }
}

