/*
 * Decompiled with CFR 0.152.
 */
package game.entities;

import game.engine.BoundingBox;
import game.engine.loader.EntityDescriptor;
import game.entities.Entity;
import game.entities.Hand;
import game.entities.HandGerm;
import game.entities.StaticImage;
import game.world.GameWorld;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.newdawn.slick.Animation;
import org.newdawn.slick.Color;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.geom.Vector2f;

public class WaterStream
extends Entity {
    private Hand[] hands = new Hand[2];
    private BoundingBox splashBBox = (BoundingBox)this.boundingBoxes.get("splash");
    private BoundingBox staticStreamBBox = (BoundingBox)this.boundingBoxes.get("water_stream");
    private static final Vector2f upperLeftStreamCorner = new Vector2f(-192.0f, -300.0f);
    private List<StaticImage> shakeableImages = new ArrayList<StaticImage>();

    public WaterStream(EntityDescriptor descriptor) {
        super(descriptor);
    }

    public void update(int dt, GameWorld world, GameContainer container) {
        float handCollisionHeight = this.checkHandCollision();
        if (handCollisionHeight < 1.0f) {
            float offsetY = -600.0f + handCollisionHeight * 30.0f;
            this.setPos(-192.0f, offsetY);
        } else {
            this.setPos(-192.0f, -300.0f);
        }
        this.checkGermCollision(dt);
    }

    public void debugRender(Graphics g, GameWorld world, GameContainer container) {
        super.debugRender(g, world, container);
        g.pushTransform();
        g.setColor(new Color(0.0f, 0.0f, 1.0f, 0.3f));
        g.fillRect(this.staticStreamBBox.getMinX(upperLeftStreamCorner), this.staticStreamBBox.getMinY(upperLeftStreamCorner), this.staticStreamBBox.getWidth(), this.staticStreamBBox.getHeight());
        g.setColor(Color.blue);
        g.drawRect(this.staticStreamBBox.getMinX(upperLeftStreamCorner), this.staticStreamBBox.getMinY(upperLeftStreamCorner), this.staticStreamBBox.getWidth(), this.staticStreamBBox.getHeight());
        g.popTransform();
        g.pushTransform();
        g.setColor(new Color(1.0f, 0.0f, 1.0f, 0.3f));
        g.fillRect(this.splashBBox.getMinX(this.getPos()), this.splashBBox.getMinY(this.getPos()), this.splashBBox.getWidth(), this.splashBBox.getHeight());
        g.setColor(Color.blue);
        g.drawRect(this.splashBBox.getMinX(this.getPos()), this.splashBBox.getMinY(this.getPos()), this.splashBBox.getWidth(), this.splashBBox.getHeight());
        g.popTransform();
    }

    public void render(Graphics g, GameWorld world, GameContainer container) {
        super.render(g, world, container);
        Animation animation = (Animation)this.animations.get("water");
        g.pushTransform();
        g.drawAnimation(animation, 0.0f, 0.0f);
        g.popTransform();
    }

    public void registerHands(Hand leftHand, Hand rightHand) {
        this.hands[0] = leftHand;
        this.hands[1] = rightHand;
    }

    private float checkHandCollision() {
        float intersectHeight = 310.0f;
        for (int i = 0; i < 2; ++i) {
            float thisIntersectHeight;
            if (!this.staticStreamBBox.intersects(upperLeftStreamCorner, this.hands[i].getBounds(), this.hands[i].getPos()) || !((thisIntersectHeight = this.hands[i].getBounds().getCenterY(this.hands[i].getPos())) < intersectHeight)) continue;
            intersectHeight = thisIntersectHeight;
            break;
        }
        return (intersectHeight - 30.0f) / 280.0f;
    }

    private void checkGermCollision(int dt) {
        int damagedGerms = 0;
        for (int i = 0; i < 2; ++i) {
            Iterator<HandGerm> it = this.hands[i].getGerms().iterator();
            while (it.hasNext()) {
                HandGerm germ = it.next();
                if (!this.splashBBox.intersects(this.getPos(), germ.getBounds(), germ.getPos())) continue;
                if (germ.doDamage(dt)) {
                    it.remove();
                }
                ++damagedGerms;
            }
        }
        if (damagedGerms > 0) {
            for (StaticImage im : this.shakeableImages) {
                im.setShake(170, (float)damagedGerms * 3.0f, (float)damagedGerms * 3.0f);
            }
        }
    }

    public void registerStaticImageToShake(StaticImage si) {
        this.shakeableImages.add(si);
    }

    public int getNumberRemainingGerms() {
        return this.hands[0].getGerms().size() + this.hands[1].getGerms().size();
    }
}

