/*
 * Decompiled with CFR 0.152.
 */
package game.entities;

import game.engine.BoundingBox;
import game.engine.loader.EntityDescriptor;
import game.entities.Entity;
import game.map.MapObject;
import game.map.MapObjectData;
import game.world.GameWorld;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.StringTokenizer;
import org.newdawn.slick.Color;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.geom.Vector2f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Waypoint
extends Entity
implements MapObject {
    private ArrayList<Link> links = new ArrayList();
    private ArrayList<LinkDescriptor> linkDescriptors = new ArrayList();
    float totalWeight;

    public Waypoint(EntityDescriptor descriptor) {
        super(descriptor);
    }

    public Collection<Link> getLinks() {
        return this.links;
    }

    public ArrayList<LinkDescriptor> getLinkDescriptors() {
        return this.linkDescriptors;
    }

    public float getTotalLinkWeight() {
        return this.totalWeight;
    }

    public void setLinks(Link ... links) {
        this.links.clear();
        this.totalWeight = 0.0f;
        for (Link link : links) {
            this.links.add(link);
            this.totalWeight += link.weight;
        }
    }

    public void setLinks(List<Link> links) {
        this.links.clear();
        this.totalWeight = 0.0f;
        for (Link link : links) {
            this.links.add(link);
            this.totalWeight += link.weight;
        }
    }

    public Waypoint pickRandomWaypoint(Random random) {
        float r = random.nextFloat() * this.totalWeight;
        float w = 0.0f;
        for (Link link : this.links) {
            if (!(r <= (w += link.weight))) continue;
            return link.waypoint;
        }
        throw new IllegalStateException("Cannot pick next waypoint.");
    }

    @Override
    public void debugRender(Graphics g, GameWorld world, GameContainer container) {
        super.debugRender(g, world, container);
        Vector2f myPos = this.getPos();
        float myX = myPos.x;
        float myY = myPos.y;
        BoundingBox myBounds = this.getBounds();
        if (myBounds != null) {
            myX = myBounds.getCenterX(myPos);
            myY = myBounds.getCenterY(myPos);
        }
        g.setColor(Color.red);
        g.fillOval(myX - 5.0f, myY - 5.0f, 10.0f, 10.0f);
        for (Link link : this.links) {
            Waypoint next = link.waypoint;
            float weight = link.weight;
            Vector2f nextPos = next.getPos();
            float nextX = nextPos.x;
            float nextY = nextPos.y;
            BoundingBox nextBounds = next.getBounds();
            if (nextBounds != null) {
                nextX = nextBounds.getCenterX(nextPos);
                nextY = nextBounds.getCenterY(nextPos);
            }
            g.setColor(Color.red);
            g.drawLine(myX, myY, nextX, nextY);
            float midX = (myX + nextX) / 2.0f;
            float midY = (myY + nextY) / 2.0f;
            g.pushTransform();
            g.translate(midX, midY);
            g.scale(0.75f, 0.75f);
            g.setColor(Color.red);
            g.drawString(String.format("%.1f%%", Float.valueOf(weight * 100.0f / this.totalWeight)), 0.0f, 0.0f);
            g.popTransform();
            float dx = nextX - myX;
            float dy = nextY - myY;
            float l = (float)Math.sqrt(dx * dx + dy * dy);
            float px = dy /= l;
            float py = -(dx /= l);
            g.drawLine(midX + 5.0f * dx, midY + 5.0f * dy, midX - 5.0f * dx + 5.0f * px, midY - 5.0f * dy + 5.0f * py);
            g.drawLine(midX + 5.0f * dx, midY + 5.0f * dy, midX - 5.0f * dx - 5.0f * px, midY - 5.0f * dy - 5.0f * py);
        }
    }

    @Override
    public void setMapData(MapObjectData data) {
        String linkTos = data.getProperty("linkTo", "null_w");
        StringTokenizer stLinkTos = new StringTokenizer(linkTos, ",");
        String linkWeights = data.getProperty("weight", "1.0");
        StringTokenizer stWeights = new StringTokenizer(linkWeights, ",");
        while (stLinkTos.hasMoreTokens() && stWeights.hasMoreTokens()) {
            String nextWaypoint = stLinkTos.nextToken().trim();
            if (nextWaypoint.equals("null_w")) continue;
            this.linkDescriptors.add(new LinkDescriptor(nextWaypoint, Float.parseFloat(stWeights.nextToken())));
        }
    }

    public static class LinkDescriptor {
        public final float weight;
        public final String waypointName;

        public LinkDescriptor(String waypointName, float weight) {
            this.waypointName = waypointName;
            this.weight = weight;
        }
    }

    public static class Link {
        public final float weight;
        public final Waypoint waypoint;

        public Link(Waypoint waypoint, float weight) {
            this.waypoint = waypoint;
            this.weight = weight;
        }
    }
}

