/*
 * Decompiled with CFR 0.152.
 */
package game.map;

import game.engine.BoundingBox;
import game.map.BlockTester;
import game.map.MapException;
import game.map.MapObjectData;
import game.map.MapPosition;
import game.map.PropertyAccessor;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import org.newdawn.slick.Color;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.geom.Line;
import org.newdawn.slick.geom.Vector2f;
import org.newdawn.slick.tiled.TiledMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GameMap {
    private TiledMap map;
    private EnumMap<LayerType, ArrayList<Integer>> layerMap;
    private ArrayList<MapObjectData> mapObjects;
    private BoundingBox goal;
    private BoundingBox bounds;

    public GameMap(final TiledMap map) throws MapException {
        this.map = map;
        this.layerMap = new EnumMap(LayerType.class);
        this.mapObjects = new ArrayList();
        for (LayerType type : LayerType.values()) {
            this.layerMap.put(type, new ArrayList());
        }
        for (int i = 0; i < map.getLayerCount(); ++i) {
            String typeName = map.getLayerProperty(i, "type", "ground");
            try {
                LayerType type = Enum.valueOf(LayerType.class, typeName);
                this.layerMap.get((Object)type).add(i);
                continue;
            }
            catch (IllegalArgumentException e) {
                throw new MapException(typeName + " is an invalid layer type.", e);
            }
        }
        int objectGroups = map.getObjectGroupCount();
        for (int i = 0; i < objectGroups; ++i) {
            int objects = map.getObjectCount(i);
            int j = 0;
            while (j < objects) {
                String name = map.getObjectName(i, j);
                String type = map.getObjectType(i, j);
                int x = map.getObjectX(i, j);
                int y = map.getObjectY(i, j);
                int width = map.getObjectWidth(i, j);
                int height = map.getObjectHeight(i, j);
                final int groupID = i;
                final int objectID = j++;
                PropertyAccessor properties = new PropertyAccessor(){

                    public String getProperty(String name, String def) {
                        return map.getObjectProperty(groupID, objectID, name, def);
                    }
                };
                MapObjectData object = new MapObjectData(name, type, this, new BoundingBox(x, y, width, height), properties);
                this.mapObjects.add(object);
            }
        }
        this.goal = new BoundingBox(0.0f, 0.0f, 0.0f, 0.0f);
        this.bounds = new BoundingBox(0.0f, 0.0f, map.getWidth() * map.getTileWidth(), map.getHeight() * map.getTileHeight());
    }

    public void renderLayers(Graphics g, LayerType type, BoundingBox bounds, Vector2f pos) {
        for (int layerId : this.layerMap.get((Object)type)) {
            this.renderLayer(g, layerId, bounds, pos);
        }
    }

    public void renderLayer(Graphics g, int layerId, BoundingBox bounds, Vector2f pos) {
        MapPosition from = this.mapPosition(bounds.getMinX(pos), bounds.getMinY(pos));
        int w = (int)Math.ceil(bounds.getWidth() / (float)this.map.getTileWidth()) + 1;
        int h = (int)Math.ceil(bounds.getHeight() / (float)this.map.getTileHeight()) + 1;
        Graphics.setCurrent(g);
        this.map.render(from.x * this.map.getTileWidth(), from.y * this.map.getTileHeight(), from.x, from.y, w, h, layerId, false);
    }

    public void debugRenderLayer(Graphics g, int layerId, BoundingBox bounds, Vector2f pos, Color color) {
        MapPosition from = this.mapPosition(bounds.getMinX(pos), bounds.getMinY(pos));
        float dx = this.map.getTileWidth();
        float dy = this.map.getTileHeight();
        Color outline = color;
        Color fill = new Color(color);
        fill.a = 0.2f;
        int w = (int)Math.ceil(bounds.getWidth() / (float)this.map.getTileWidth()) + 1;
        int h = (int)Math.ceil(bounds.getHeight() / (float)this.map.getTileHeight()) + 1;
        int fromx = Math.max(0, from.x);
        int fromy = Math.max(0, from.y);
        int tox = Math.min(from.x + w, this.map.getWidth());
        int toy = Math.min(from.y + h, this.map.getHeight());
        for (int y = fromy; y < toy; ++y) {
            for (int x = fromx; x < tox; ++x) {
                if (this.map.getTileId(x, y, layerId) == 0) continue;
                g.setColor(fill);
                g.fillRect(dx * (float)x, dy * (float)y, dx, dy);
                g.setColor(outline);
                g.drawRect(dx * (float)x, dy * (float)y, dx, dy);
            }
        }
    }

    public int getLayerId(String name) {
        return this.map.getLayerIndex(name);
    }

    public boolean isBlocked(BoundingBox boundingBox, Vector2f pos) {
        MapPosition from = this.mapPosition(boundingBox.getMinX(pos), boundingBox.getMinY(pos));
        MapPosition to = this.mapPosition(boundingBox.getMaxX(pos) - 0.01f, boundingBox.getMaxY(pos) - 0.01f);
        for (int x = from.x; x <= to.x; ++x) {
            for (int y = from.y; y <= to.y; ++y) {
                if (!this.isTileBlocked(x, y)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isBlocked(Line line, BlockTester tester) {
        int tmp;
        boolean steep;
        float x0 = line.getX1();
        float x1 = line.getX2();
        float y0 = line.getY1();
        float y1 = line.getY2();
        MapPosition pos0 = this.mapPosition(x0, y0);
        MapPosition pos1 = this.mapPosition(x1, y1);
        int p0x = pos0.x;
        int p0y = pos0.y;
        int p1x = pos1.x;
        int p1y = pos1.y;
        boolean bl = steep = Math.abs(p1y - p0y) > Math.abs(p1x - p0x);
        if (steep) {
            tmp = p0x;
            p0x = p0y;
            p0y = tmp;
            tmp = p1x;
            p1x = p1y;
            p1y = tmp;
        }
        if (p0x > p1x) {
            tmp = p0x;
            p0x = p1x;
            p1x = tmp;
            tmp = p0y;
            p0y = p1y;
            p1y = tmp;
        }
        int deltaX = p1x - p0x;
        int deltaY = Math.abs(p1y - p0y);
        float error = 0.0f;
        float deltaError = (float)deltaY / (float)deltaX;
        int yStep = p0y < p1y ? 1 : -1;
        int y = p0y;
        for (int x = p0x; x <= p1x; ++x) {
            if (steep ? this.isTileBlocked(y, x) || tester != null && tester.isBlocked(this.unmapPosition(y, x)) : this.isTileBlocked(x, y) || tester != null && tester.isBlocked(this.unmapPosition(x, y))) {
                return true;
            }
            if (!((error += deltaError) >= 0.5f)) continue;
            y += yStep;
            error -= 1.0f;
        }
        return false;
    }

    public boolean isBlocked(Vector2f pos) {
        return this.isTileBlocked(this.mapPosition(pos.x, pos.y));
    }

    public boolean isTileBlocked(MapPosition pos) {
        return this.isTileBlocked(pos.x, pos.y);
    }

    public boolean isTileBlocked(int x, int y) {
        if (x < 0 || y < 0 || x >= this.map.getWidth() || y >= this.map.getHeight()) {
            return true;
        }
        for (int layerId : this.layerMap.get((Object)LayerType.wall)) {
            if (this.map.getTileId(x, y, layerId) == 0) continue;
            return true;
        }
        for (int layerId : this.layerMap.get((Object)LayerType.ground)) {
            if (this.map.getTileId(x, y, layerId) == 0) continue;
            return false;
        }
        return true;
    }

    private MapPosition mapPosition(float x, float y) {
        float tx = x / (float)this.map.getTileWidth();
        float ty = y / (float)this.map.getTileHeight();
        return new MapPosition(Math.min((int)tx, this.map.getWidth() - 1), Math.min((int)ty, this.map.getHeight() - 1));
    }

    public BoundingBox getBounds() {
        return this.bounds;
    }

    public BoundingBox getTileBounds() {
        return new BoundingBox(-0.5f * (float)this.map.getTileWidth(), -0.5f * (float)this.map.getTileHeight(), this.map.getTileWidth(), this.map.getTileHeight());
    }

    public Vector2f getTilePos(Vector2f pos) {
        return this.alignPosition(pos);
    }

    public List<MapObjectData> getObjects() {
        return this.mapObjects;
    }

    public BoundingBox getGoalBounds() {
        return this.goal;
    }

    public void setGoalBounds(BoundingBox goal) {
        this.goal = goal;
    }

    public Vector2f alignPosition(Vector2f pos) {
        MapPosition p = this.mapPosition(pos.x, pos.y);
        return new Vector2f(((float)p.x + 0.5f) * (float)this.map.getTileWidth(), ((float)p.y + 0.5f) * (float)this.map.getTileHeight());
    }

    private Vector2f unmapPosition(int x, int y) {
        return new Vector2f(((float)x + 0.5f) * (float)this.map.getTileWidth(), ((float)y + 0.5f) * (float)this.map.getTileHeight());
    }

    public int getLayerCount() {
        return this.map.getLayerCount();
    }

    public int getWidth() {
        return this.map.getWidth();
    }

    public int getHeight() {
        return this.map.getHeight();
    }

    public boolean isLayerBlocked(int id, BoundingBox boundingBox, Vector2f pos) {
        MapPosition from = this.mapPosition(boundingBox.getMinX(pos), boundingBox.getMinY(pos));
        MapPosition to = this.mapPosition(boundingBox.getMaxX(pos) - 0.01f, boundingBox.getMaxY(pos) - 0.01f);
        for (int x = from.x; x <= to.x; ++x) {
            for (int y = from.y; y <= to.y; ++y) {
                if (!this.isLayerTileBlocked(id, x, y)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isLayerTileBlocked(int id, int x, int y) {
        if (x < 0 || y < 0 || x >= this.map.getWidth() || y >= this.map.getHeight()) {
            return false;
        }
        return this.map.getTileId(x, y, id) != 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LayerType {
        ground,
        wall,
        occlusion,
        object,
        roof;

    }
}

