/*
 * Decompiled with CFR 0.152.
 */
package game.map;

import game.engine.BoundingBox;
import game.map.GameMap;
import game.map.PropertyAccessor;

public class MapObjectData
implements PropertyAccessor {
    private final String name;
    private final String type;
    private final BoundingBox rectangle;
    private final PropertyAccessor properties;
    private final GameMap map;

    MapObjectData(String name, String type, GameMap map, BoundingBox boundingBox, PropertyAccessor properties) {
        this.name = name;
        this.type = type;
        this.map = map;
        this.rectangle = boundingBox;
        this.properties = properties;
    }

    public GameMap getMap() {
        return this.map;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public BoundingBox getRectangle() {
        return this.rectangle;
    }

    public boolean isTypeOrName(String id) {
        return this.type.equalsIgnoreCase(id) || this.name.equalsIgnoreCase(id);
    }

    public String getProperty(String name, String def) {
        return this.properties.getProperty(name, def);
    }

    public int getIntProperty(String name, int def) {
        return Integer.parseInt(this.getProperty(name, String.valueOf(def)));
    }

    public float getFloatProperty(String name, float def) {
        return Float.parseFloat(this.getProperty(name, String.valueOf(def)));
    }

    public boolean getBooleanProperty(String name, boolean def) {
        return Boolean.parseBoolean(this.getProperty(name, String.valueOf(def)));
    }
}

