/*
 * Decompiled with CFR 0.152.
 */
package game.map;

import game.engine.BoundingBox;
import game.entities.Character;
import game.map.GameMap;
import org.newdawn.slick.geom.Vector2f;
import org.newdawn.slick.util.pathfinding.Mover;
import org.newdawn.slick.util.pathfinding.PathFindingContext;
import org.newdawn.slick.util.pathfinding.TileBasedMap;

public class TileBasedMapAdapter
implements TileBasedMap {
    private GameMap map;
    private float tileSize;

    public TileBasedMapAdapter(GameMap map, float tileSize) {
        this.map = map;
        this.tileSize = tileSize;
    }

    private Character getCharacter(PathFindingContext ctx) {
        return ((TileBasedMover)ctx.getMover()).getCharacter();
    }

    private Vector2f getPosition(int tx, int ty) {
        return new Vector2f((float)tx * this.tileSize, (float)ty * this.tileSize);
    }

    public boolean blocked(PathFindingContext ctx, int tx, int ty) {
        Vector2f cpos;
        Character character = this.getCharacter(ctx);
        BoundingBox cbb = character.getCollisionBox();
        return this.map.isBlocked(cbb, cpos = this.getPosition(tx, ty));
    }

    public float getCost(PathFindingContext ctx, int tx, int ty) {
        int sx = ctx.getSourceX();
        int sy = ctx.getSourceY();
        if (sx != tx && sy != ty) {
            return 1.4142135f;
        }
        return 1.0f;
    }

    public int getHeightInTiles() {
        return (int)(this.map.getBounds().getHeight() / this.tileSize);
    }

    public int getWidthInTiles() {
        return (int)(this.map.getBounds().getWidth() / this.tileSize);
    }

    public void pathFinderVisited(int tx, int ty) {
    }

    public static class TileBasedMover
    implements Mover {
        private Character character;

        public TileBasedMover(Character character) {
            this.character = character;
        }

        public Character getCharacter() {
            return this.character;
        }
    }
}

