/*
 * Decompiled with CFR 0.152.
 */
package game.world;

import game.GameConfig;
import game.engine.loader.EntityLoader;
import game.entities.Hand;
import game.entities.HandGerm;
import game.entities.StaticImage;
import game.entities.WashBar;
import game.entities.WaterStream;
import game.world.GameWorld;
import org.newdawn.slick.GameContainer;

public class HandWashingGameWorld
extends GameWorld {
    private static final int NUM_GERMS = 40;
    private static final int GAME_DURATION = 7000;
    private int gameTimeLeft;
    private Hand[] hands = new Hand[2];
    private StaticImage faucet;
    private StaticImage sinkBackground;
    private StaticImage text_overlay;
    private WaterStream waterStream;
    private WashBar washBar;
    private HandGerm[] leftGerms;
    private HandGerm[] rightGerms;
    private boolean isGolden;

    public HandWashingGameWorld(EntityLoader loader, GameConfig config, GameContainer container) {
        super(loader, config, container);
        this.hands[0] = (Hand)loader.create("left_hand");
        this.objects.add(this.hands[0]);
        this.hands[1] = (Hand)loader.create("right_hand");
        this.objects.add(this.hands[1]);
        this.faucet = (StaticImage)loader.create("faucet");
        this.objects.add(this.faucet);
        this.sinkBackground = (StaticImage)loader.create("sink_background");
        this.objects.add(this.sinkBackground);
        this.text_overlay = (StaticImage)loader.create("wash_them_germs");
        this.objects.add(this.text_overlay);
        this.waterStream = (WaterStream)loader.create("water_stream");
        this.waterStream.registerHands(this.hands[0], this.hands[1]);
        this.waterStream.registerStaticImageToShake(this.sinkBackground);
        this.waterStream.registerStaticImageToShake(this.faucet);
        this.objects.add(this.waterStream);
        this.leftGerms = new HandGerm[40];
        this.rightGerms = new HandGerm[40];
        for (int i = 0; i < 40; ++i) {
            this.leftGerms[i] = (HandGerm)loader.create("left_hand_germ");
            this.leftGerms[i].changeAnimation(this.random);
            this.objects.add(this.leftGerms[i]);
            this.rightGerms[i] = (HandGerm)loader.create("right_hand_germ");
            this.rightGerms[i].changeAnimation(this.random);
            this.objects.add(this.rightGerms[i]);
        }
        this.washBar = (WashBar)loader.create("wash_bar");
        this.objects.add(this.washBar);
    }

    public boolean isGameFinished() {
        return !this.isGolden && this.gameTimeLeft < 0 || this.waterStream.getNumberRemainingGerms() == 0;
    }

    public void resetHandWashing(float playerGermLevel) {
        int i;
        this.gameTimeLeft = 7000;
        this.hands[0].setPos(-500.0f, -250.0f);
        this.hands[1].setPos(0.0f, -250.0f);
        this.faucet.setPos(-120.0f, -300.0f);
        this.sinkBackground.setPos(-400.0f, -300.0f);
        this.text_overlay.setPos(-400.0f, 150.0f);
        this.waterStream.setPos(-192.0f, -768.0f);
        this.hands[0].clearGerms();
        this.hands[1].clearGerms();
        float ratioGermsOnLeft = this.random.nextFloat();
        int germsOnLeft = (int)(ratioGermsOnLeft * (playerGermLevel * 40.0f));
        int germsOnRight = (int)((1.0f - ratioGermsOnLeft) * (playerGermLevel * 40.0f));
        for (i = 0; i < germsOnLeft; ++i) {
            this.leftGerms[i].setPos(this.hands[0].generateGermPosition(this.random));
            this.hands[0].attachGerm(this.leftGerms[i]);
        }
        for (i = 0; i < germsOnRight; ++i) {
            this.rightGerms[i].setPos(this.hands[1].generateGermPosition(this.random));
            this.hands[1].attachGerm(this.rightGerms[i]);
        }
    }

    public void update(int dt, GameContainer container) {
        this.washBar.updateRemainingTime((float)this.gameTimeLeft / 7000.0f);
        super.update(dt, container);
        if (!this.isGolden) {
            this.gameTimeLeft -= dt;
        }
    }

    public float getPlayerGermLevel() {
        return (float)this.waterStream.getNumberRemainingGerms() / 40.0f;
    }

    public void setGolden(boolean isGolden) {
        this.isGolden = isGolden;
        this.washBar.setGolden(isGolden);
    }
}

