/*
 * Decompiled with CFR 0.152.
 */
package game.world;

import game.GameConfig;
import game.engine.loader.EntityDescriptor;
import game.engine.loader.EntityLoader;
import game.entities.Enemy;
import game.entities.GermBar;
import game.entities.Player;
import game.entities.Waypoint;
import game.world.MapGameWorld;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.geom.Vector2f;

public class LDGameWorld
extends MapGameWorld {
    private static final float ENEMY_DISTANCE_MAX = 350.0f;
    private static final float ENEMY_DISTANCE_MIN = 150.0f;
    private boolean washingHands;
    private Player player;
    private boolean levelTransition;
    private boolean isGolden;
    private boolean victory;

    public LDGameWorld(EntityLoader loader, GameConfig config, GameContainer container) {
        super(loader, config, container);
        GermBar germBar = (GermBar)loader.create("GermBar");
        this.player = this.objects.getOne(Player.class);
        this.player.setGermBar(germBar);
        this.objects.add(this.player);
        this.objects.add(germBar);
        if (this.player != null) {
            this.getCamera().addEntity(this.player);
        }
        this.washingHands = false;
        this.levelTransition = false;
        this.victory = false;
        this.linkWaypoints();
        this.spawnEnemiesAlongWaypointPaths();
    }

    public void update(int dt, GameContainer container) {
        super.update(dt, container);
    }

    public void transitionToLevel(String level) {
        this.getConfig().level = level;
        this.levelTransition = true;
    }

    public void spawnEnemiesAlongWaypointPaths() {
        EntityDescriptor enemyDescriptor;
        ArrayList<EntityDescriptor> enemyTypes = new ArrayList<EntityDescriptor>();
        int i = 1;
        while ((enemyDescriptor = this.loader.getEntityDescriptor("enemy" + String.valueOf(i))) != null) {
            enemyTypes.add(enemyDescriptor);
            ++i;
        }
        float totalChance = 0.0f;
        float[] chanceLimits = new float[enemyTypes.size()];
        for (int i2 = 0; i2 < enemyTypes.size(); ++i2) {
            EntityDescriptor descriptor = (EntityDescriptor)enemyTypes.get(i2);
            chanceLimits[i2] = totalChance += descriptor.properties.getFloat("chance", 1.0f);
        }
        Vector2f from = new Vector2f();
        Vector2f to = new Vector2f();
        Vector2f pos = new Vector2f();
        Iterator i$ = this.objects.get(Waypoint.class).iterator();
        while (i$.hasNext()) {
            Waypoint w = (Waypoint)i$.next();
            w.getCenter(from);
            for (Waypoint.Link l : w.getLinks()) {
                l.waypoint.getCenter(to);
                float linkLength = from.distance(to);
                float t = 0.0f;
                while (t < linkLength) {
                    float r = (t += this.random.nextFloat() * 200.0f + 150.0f) / linkLength;
                    pos.x = (1.0f - r) * from.x + r * to.x;
                    pos.y = (1.0f - r) * from.y + r * to.y;
                    r = this.random.nextFloat() * totalChance;
                    int i3 = Arrays.binarySearch(chanceLimits, r);
                    if (i3 < 0) {
                        i3 = -i3 - 1;
                    }
                    EntityDescriptor descriptor = (EntityDescriptor)enemyTypes.get(i3);
                    Enemy enemy = (Enemy)this.loader.create(descriptor.name);
                    enemy.setPos(pos);
                    enemy.setWaypoints(w, l.waypoint, this.random);
                    this.objects.add(enemy);
                }
            }
        }
    }

    public void linkWaypoints() {
        Class<Waypoint> waypoints = this.objects.get(Waypoint.class);
        Iterator i$ = waypoints.iterator();
        while (i$.hasNext()) {
            Waypoint w = (Waypoint)i$.next();
            ArrayList<Waypoint.Link> links = new ArrayList<Waypoint.Link>();
            block1: for (Waypoint.LinkDescriptor ld : w.getLinkDescriptors()) {
                Iterator i$2 = waypoints.iterator();
                while (i$2.hasNext()) {
                    Waypoint w1 = (Waypoint)i$2.next();
                    StringTokenizer st = new StringTokenizer(w1.getName());
                    if (!st.nextToken().equals(ld.waypointName)) continue;
                    links.add(new Waypoint.Link(w1, ld.weight));
                    continue block1;
                }
            }
            w.setLinks(links);
        }
    }

    public void setIsWashingHands(boolean washingHands, boolean isGolden) {
        this.washingHands = washingHands;
        this.isGolden = isGolden;
    }

    public boolean isPlayerWashingHands() {
        return this.washingHands;
    }

    public boolean isInLevelTransition() {
        return this.levelTransition;
    }

    public boolean isVictoryAchieved() {
        return this.victory;
    }

    public void winGame() {
        this.victory = true;
    }

    public Player getPlayer() {
        return this.player;
    }

    public boolean isPlayerUsingGolden() {
        return this.isGolden;
    }
}

