/*
 * Decompiled with CFR 0.152.
 */
package game.world;

import game.GameConfig;
import game.engine.BoundingBox;
import game.engine.loader.EntityLoader;
import game.engine.path.PathFindingSystem;
import game.entities.Entity;
import game.entities.MapLayer;
import game.map.GameMap;
import game.map.MapException;
import game.map.MapObject;
import game.map.MapObjectData;
import game.world.GameWorld;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.geom.Vector2f;
import org.newdawn.slick.tiled.TiledMap;

public class MapGameWorld
extends GameWorld {
    private static final String LEVEL_PATH = "assets/levels";
    private GameMap map;
    private PathFindingSystem pathSystem;
    private int debugMapLayer = -1;

    public MapGameWorld(EntityLoader loader, GameConfig config, GameContainer container) {
        super(loader, config, container);
        if (config.level == null || config.level.isEmpty()) {
            throw new IllegalStateException("No level to load.");
        }
        String level = "assets/levels/" + config.level;
        this.loadLevel(loader, level);
    }

    private void loadLevel(EntityLoader loader, String level) {
        try {
            TiledMap tiledMap = new TiledMap(level, LEVEL_PATH);
            this.map = new GameMap(tiledMap);
        }
        catch (MapException e) {
            e.printStackTrace();
            System.exit(1);
        }
        catch (SlickException e) {
            e.printStackTrace();
            System.exit(1);
        }
        Vector2f pos = new Vector2f();
        for (MapObjectData data : this.map.getObjects()) {
            Entity entity = (Entity)loader.create(data.getType());
            entity.setInstanceName(data.getName());
            if (entity instanceof MapObject) {
                MapObject mapObject = (MapObject)((Object)entity);
                mapObject.setMapData(data);
            }
            BoundingBox bb = entity.getBounds();
            pos.x = data.getRectangle().getCenterX(0.0f, 0.0f) - (bb == null ? 0.0f : bb.getCenterX(0.0f, 0.0f));
            pos.y = data.getRectangle().getCenterY(0.0f, 0.0f) - (bb == null ? 0.0f : bb.getCenterY(0.0f, 0.0f));
            entity.setPos(pos);
            this.getEntities().add(entity);
        }
        this.pathSystem = new PathFindingSystem(this.map);
        this.pathSystem.initialize();
        this.objects.add((MapLayer)loader.create("map_layer_above"));
        this.objects.add((MapLayer)loader.create("map_layer_collision"));
        this.objects.add((MapLayer)loader.create("map_layer_ground"));
    }

    public void update(int dt, GameContainer container) {
        if (container.getInput().isKeyPressed(68)) {
            ++this.debugMapLayer;
            if (this.debugMapLayer == this.map.getLayerCount()) {
                this.debugMapLayer = -1;
            }
        }
        super.update(dt, container);
    }

    public GameMap getMap() {
        return this.map;
    }

    public PathFindingSystem getPathSystem() {
        return this.pathSystem;
    }

    public int getDebugMapLayerId() {
        return this.debugMapLayer;
    }

    protected void getDebugSidebarText(StringBuilder sb) {
        super.getDebugSidebarText(sb);
        sb.append(String.format("Debug layer: %s/%d (F10)\n", this.debugMapLayer >= 0 ? String.valueOf(this.debugMapLayer + 1) : "-", this.map.getLayerCount()));
    }

    public boolean collisionCheck(Vector2f aPosition, BoundingBox anAABB) {
        return this.map.isBlocked(anAABB, aPosition);
    }

    protected void debugRenderSystems(Graphics g, GameContainer container) {
        super.debugRenderSystems(g, container);
        if (this.debugEntities) {
            g.pushTransform();
            this.camera.applyTransform(g, container);
            this.pathSystem.debugRender(g);
            g.popTransform();
        }
    }
}

