/*
 * Decompiled with CFR 0.152.
 */
package org.poly2tri.triangulation;

import java.util.ArrayList;
import org.poly2tri.geometry.primitives.Point;
import org.poly2tri.triangulation.delaunay.sweep.DTSweepConstraint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TriangulationPoint
extends Point {
    private ArrayList<DTSweepConstraint> edges;

    public String toString() {
        return "[" + this.getX() + "," + this.getY() + "]";
    }

    @Override
    public abstract double getX();

    @Override
    public abstract double getY();

    @Override
    public abstract double getZ();

    @Override
    public abstract float getXf();

    @Override
    public abstract float getYf();

    @Override
    public abstract float getZf();

    @Override
    public abstract void set(double var1, double var3, double var5);

    public ArrayList<DTSweepConstraint> getEdges() {
        return this.edges;
    }

    public void addEdge(DTSweepConstraint e) {
        if (this.edges == null) {
            this.edges = new ArrayList();
        }
        this.edges.add(e);
    }

    public boolean hasEdges() {
        return this.edges != null;
    }

    public DTSweepConstraint getEdge(TriangulationPoint p) {
        for (DTSweepConstraint c : this.edges) {
            if (c.p != p) continue;
            return c;
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (obj instanceof TriangulationPoint) {
            TriangulationPoint p = (TriangulationPoint)obj;
            return this.getX() == p.getX() && this.getY() == p.getY();
        }
        return super.equals(obj);
    }

    public int hashCode() {
        long bits = Double.doubleToLongBits(this.getX());
        return (int)(bits ^= Double.doubleToLongBits(this.getY()) * 31L) ^ (int)(bits >> 32);
    }
}

