/*
 * Decompiled with CFR 0.152.
 */
package org.poly2tri.triangulation;

import java.util.ArrayList;
import java.util.List;
import org.poly2tri.Poly2Tri;
import org.poly2tri.geometry.polygon.Polygon;
import org.poly2tri.geometry.polygon.PolygonSet;
import org.poly2tri.triangulation.Triangulatable;
import org.poly2tri.triangulation.TriangulationAlgorithm;
import org.poly2tri.triangulation.TriangulationContext;
import org.poly2tri.triangulation.TriangulationProcessEvent;
import org.poly2tri.triangulation.TriangulationProcessListener;
import org.poly2tri.triangulation.sets.ConstrainedPointSet;
import org.poly2tri.triangulation.sets.PointSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TriangulationProcess
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(TriangulationProcess.class);
    private final TriangulationAlgorithm _algorithm;
    private TriangulationContext<?> _tcx;
    private Thread _thread;
    private boolean _isTerminated = false;
    private int _pointCount = 0;
    private long _timestamp = 0L;
    private double _triangulationTime = 0.0;
    private boolean _awaitingTermination;
    private boolean _restart = false;
    private ArrayList<Triangulatable> _triangulations = new ArrayList();
    private ArrayList<TriangulationProcessListener> _listeners = new ArrayList();

    public void addListener(TriangulationProcessListener listener) {
        this._listeners.add(listener);
    }

    public void removeListener(TriangulationProcessListener listener) {
        this._listeners.remove(listener);
    }

    public void clearListeners() {
        this._listeners.clear();
    }

    private void sendEvent(TriangulationProcessEvent event) {
        for (TriangulationProcessListener l : this._listeners) {
            l.triangulationEvent(event, this._tcx.getTriangulatable());
        }
    }

    public int getStepCount() {
        return this._tcx.getStepCount();
    }

    public long getTimestamp() {
        return this._timestamp;
    }

    public double getTriangulationTime() {
        return this._triangulationTime;
    }

    public TriangulationProcess() {
        this(TriangulationAlgorithm.DTSweep);
    }

    public TriangulationProcess(TriangulationAlgorithm algorithm) {
        this._algorithm = algorithm;
        this._tcx = Poly2Tri.createContext(algorithm);
    }

    public void triangulate(PointSet ps) {
        this._triangulations.clear();
        this._triangulations.add(ps);
        this.start();
    }

    public void triangulate(ConstrainedPointSet cps) {
        this._triangulations.clear();
        this._triangulations.add(cps);
        this.start();
    }

    public void triangulate(PolygonSet ps) {
        this._triangulations.clear();
        this._triangulations.addAll(ps.getPolygons());
        this.start();
    }

    public void triangulate(Polygon polygon) {
        this._triangulations.clear();
        this._triangulations.add(polygon);
        this.start();
    }

    public void triangulate(List<Triangulatable> list) {
        this._triangulations.clear();
        this._triangulations.addAll(list);
        this.start();
    }

    private void start() {
        if (this._thread == null || this._thread.getState() == Thread.State.TERMINATED) {
            this._isTerminated = false;
            this._thread = new Thread((Runnable)this, String.valueOf(this._algorithm.name()) + "." + (Object)((Object)this._tcx.getTriangulationMode()));
            this._thread.start();
            this.sendEvent(TriangulationProcessEvent.Started);
        } else {
            this.shutdown();
            this._restart = true;
        }
    }

    public boolean isWaiting() {
        return this._thread != null && this._thread.getState() == Thread.State.WAITING;
    }

    @Override
    public void run() {
        block11: {
            this._pointCount = 0;
            try {
                long time = System.nanoTime();
                for (Triangulatable t : this._triangulations) {
                    this._tcx.clear();
                    this._tcx.prepareTriangulation(t);
                    this._pointCount += this._tcx._points.size();
                    Poly2Tri.triangulate(this._tcx);
                }
                this._triangulationTime = (double)(System.nanoTime() - time) / 1000000.0;
                logger.info("Triangulation of {} points [{}ms]", (Object)this._pointCount, (Object)this._triangulationTime);
                this.sendEvent(TriangulationProcessEvent.Done);
            }
            catch (RuntimeException e) {
                if (this._awaitingTermination) {
                    this._awaitingTermination = false;
                    logger.info("Thread[{}] : {}", (Object)this._thread.getName(), (Object)e.getMessage());
                    this.sendEvent(TriangulationProcessEvent.Aborted);
                } else {
                    e.printStackTrace();
                    this.sendEvent(TriangulationProcessEvent.Failed);
                }
                this._timestamp = System.currentTimeMillis();
                this._isTerminated = true;
                this._thread = null;
                break block11;
            }
            catch (Exception e) {
                try {
                    e.printStackTrace();
                    logger.info("Triangulation exception {}", (Object)e.getMessage());
                    this.sendEvent(TriangulationProcessEvent.Failed);
                    break block11;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    this._timestamp = System.currentTimeMillis();
                    this._isTerminated = true;
                    this._thread = null;
                }
            }
            this._timestamp = System.currentTimeMillis();
            this._isTerminated = true;
            this._thread = null;
        }
        if (this._restart) {
            this._restart = false;
            this.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        if (this._thread != null) {
            if (this._thread.getState() == Thread.State.WAITING) {
                TriangulationContext<?> triangulationContext = this._tcx;
                synchronized (triangulationContext) {
                    this._tcx.notify();
                }
            } else if (this._thread.getState() == Thread.State.TIMED_WAITING) {
                this._tcx.waitUntilNotified(false);
            }
        }
    }

    public void shutdown() {
        this._awaitingTermination = true;
        this._tcx.terminateTriangulation();
        this.resume();
    }

    public TriangulationContext<?> getContext() {
        return this._tcx;
    }

    public boolean isDone() {
        return this._isTerminated;
    }

    public void requestRead() {
        this._tcx.waitUntilNotified(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isReadable() {
        if (this._thread == null) {
            return true;
        }
        Thread thread = this._thread;
        synchronized (thread) {
            block7: {
                block6: {
                    if (this._thread.getState() != Thread.State.WAITING) break block6;
                    return true;
                }
                if (this._thread.getState() != Thread.State.TIMED_WAITING) break block7;
                this._tcx.waitUntilNotified(true);
                return true;
            }
            return false;
        }
    }

    public int getPointCount() {
        return this._pointCount;
    }
}

