/*
 * Decompiled with CFR 0.152.
 */
package org.poly2tri.triangulation.sets;

import java.util.ArrayList;
import java.util.List;
import org.poly2tri.triangulation.Triangulatable;
import org.poly2tri.triangulation.TriangulationContext;
import org.poly2tri.triangulation.TriangulationMode;
import org.poly2tri.triangulation.TriangulationPoint;
import org.poly2tri.triangulation.delaunay.DelaunayTriangle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PointSet
implements Triangulatable {
    List<TriangulationPoint> _points = new ArrayList<TriangulationPoint>();
    List<DelaunayTriangle> _triangles;

    public PointSet(List<TriangulationPoint> points) {
        this._points.addAll(points);
    }

    @Override
    public TriangulationMode getTriangulationMode() {
        return TriangulationMode.UNCONSTRAINED;
    }

    @Override
    public List<TriangulationPoint> getPoints() {
        return this._points;
    }

    @Override
    public List<DelaunayTriangle> getTriangles() {
        return this._triangles;
    }

    @Override
    public void addTriangle(DelaunayTriangle t) {
        this._triangles.add(t);
    }

    @Override
    public void addTriangles(List<DelaunayTriangle> list) {
        this._triangles.addAll(list);
    }

    @Override
    public void clearTriangulation() {
        this._triangles.clear();
    }

    @Override
    public void prepareTriangulation(TriangulationContext<?> tcx) {
        if (this._triangles == null) {
            this._triangles = new ArrayList<DelaunayTriangle>(this._points.size());
        } else {
            this._triangles.clear();
        }
        tcx.addPoints(this._points);
    }
}

