/*
 * Decompiled with CFR 0.152.
 */
package org.poly2tri.triangulation.util;

import java.util.ArrayList;
import java.util.List;
import org.poly2tri.triangulation.TriangulationPoint;
import org.poly2tri.triangulation.point.TPoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PointGenerator {
    public static List<TriangulationPoint> uniformDistribution(int n, double scale) {
        ArrayList<TriangulationPoint> points = new ArrayList<TriangulationPoint>();
        int i = 0;
        while (i < n) {
            points.add(new TPoint(scale * (0.5 - Math.random()), scale * (0.5 - Math.random())));
            ++i;
        }
        return points;
    }

    public static List<TriangulationPoint> uniformGrid(int n, double scale) {
        double x = 0.0;
        double size = scale / (double)n;
        double halfScale = 0.5 * scale;
        ArrayList<TriangulationPoint> points = new ArrayList<TriangulationPoint>();
        int i = 0;
        while (i < n + 1) {
            x = halfScale - (double)i * size;
            int j = 0;
            while (j < n + 1) {
                points.add(new TPoint(x, halfScale - (double)j * size));
                ++j;
            }
            ++i;
        }
        return points;
    }
}

