/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.CollisionHandler;
import game.entities.Entity;
import game.world.GameWorld;
import java.util.HashSet;
import org.jbox2d.callbacks.ContactImpulse;
import org.jbox2d.callbacks.ContactListener;
import org.jbox2d.collision.Manifold;
import org.jbox2d.dynamics.contacts.Contact;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollisionManager
implements ContactListener {
    private GameWorld world;
    private HashSet<TypePair<? extends Entity, ? extends Entity>> handlers;

    public CollisionManager(GameWorld world) {
        this.world = world;
        this.handlers = new HashSet();
    }

    public <A extends Entity, B extends Entity> void registerHandler(Class<A> typeA, Class<B> typeB, CollisionHandler<A, B> handler) {
        this.handlers.add(new TypePair<A, B>(typeA, typeB, handler));
        if (!typeA.equals(typeB)) {
            this.handlers.add(new TypePair<B, A>(typeB, typeA, new InvertHandler<B, A>(handler)));
        }
    }

    @Override
    public void beginContact(Contact c) {
        Entity a = (Entity)c.getFixtureA().getBody().getUserData();
        Entity b = (Entity)c.getFixtureB().getBody().getUserData();
        for (TypePair<? extends Entity, ? extends Entity> handler : this.handlers) {
            handler.beginContact(this.world, a, b, c);
        }
    }

    @Override
    public void endContact(Contact c) {
        Entity a = (Entity)c.getFixtureA().getBody().getUserData();
        Entity b = (Entity)c.getFixtureB().getBody().getUserData();
        for (TypePair<? extends Entity, ? extends Entity> handler : this.handlers) {
            handler.endContact(this.world, a, b, c);
        }
    }

    @Override
    public void postSolve(Contact c, ContactImpulse i) {
        Entity a = (Entity)c.getFixtureA().getBody().getUserData();
        Entity b = (Entity)c.getFixtureB().getBody().getUserData();
        for (TypePair<? extends Entity, ? extends Entity> handler : this.handlers) {
            handler.postSolve(this.world, a, b, c, i);
        }
    }

    @Override
    public void preSolve(Contact c, Manifold m) {
        Entity a = (Entity)c.getFixtureA().getBody().getUserData();
        Entity b = (Entity)c.getFixtureB().getBody().getUserData();
        for (TypePair<? extends Entity, ? extends Entity> handler : this.handlers) {
            handler.preSolve(this.world, a, b, c, m);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TypePair<A extends Entity, B extends Entity> {
        public final Class<A> typeA;
        public final Class<B> typeB;
        private CollisionHandler<A, B> handler;

        public TypePair(Class<A> typeA, Class<B> typeB, CollisionHandler<A, B> handler) {
            this.typeA = typeA;
            this.typeB = typeB;
            this.handler = handler;
        }

        public void beginContact(GameWorld world, Entity a, Entity b, Contact c) {
            if (this.typeA.isAssignableFrom(a.getClass()) && this.typeB.isAssignableFrom(b.getClass())) {
                this.handler.beginContact(world, (Entity)this.typeA.cast(a), (Entity)this.typeB.cast(b), c);
            }
        }

        public void endContact(GameWorld world, Entity a, Entity b, Contact c) {
            if (this.typeA.isAssignableFrom(a.getClass()) && this.typeB.isAssignableFrom(b.getClass())) {
                this.handler.endContact(world, (Entity)this.typeA.cast(a), (Entity)this.typeB.cast(b), c);
            }
        }

        public void postSolve(GameWorld world, Entity a, Entity b, Contact c, ContactImpulse i) {
            if (this.typeA.isAssignableFrom(a.getClass()) && this.typeB.isAssignableFrom(b.getClass())) {
                this.handler.postSolve(world, (Entity)this.typeA.cast(a), (Entity)this.typeB.cast(b), c, i);
            }
        }

        public void preSolve(GameWorld world, Entity a, Entity b, Contact c, Manifold m) {
            if (this.typeA.isAssignableFrom(a.getClass()) && this.typeB.isAssignableFrom(b.getClass())) {
                this.handler.preSolve(world, (Entity)this.typeA.cast(a), (Entity)this.typeB.cast(b), c, m);
            }
        }

        public boolean equals(Object obj) {
            if (obj instanceof TypePair) {
                TypePair o = (TypePair)obj;
                return this.typeA.equals(o.typeA) && this.typeB.equals(o.typeB);
            }
            return false;
        }

        public int hashCode() {
            return this.typeA.hashCode() + this.typeB.hashCode() * 1337;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class InvertHandler<A extends Entity, B extends Entity>
    implements CollisionHandler<A, B> {
        private CollisionHandler<B, A> handler;

        public InvertHandler(CollisionHandler<B, A> handler) {
            this.handler = handler;
        }

        @Override
        public void beginContact(GameWorld world, A a, B b, Contact c) {
            this.handler.beginContact(world, b, a, c);
        }

        @Override
        public void endContact(GameWorld world, A a, B b, Contact c) {
            this.handler.endContact(world, b, a, c);
        }

        @Override
        public void postSolve(GameWorld world, A a, B b, Contact c, ContactImpulse i) {
            this.handler.postSolve(world, b, a, c, i);
        }

        @Override
        public void preSolve(GameWorld world, A a, B b, Contact c, Manifold m) {
            this.handler.preSolve(world, b, a, c, m);
        }
    }
}

