/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.MyTinyWorldGame;
import game.MyTinyWorldGameOver;
import game.MyTinyWorldTitle;
import game.engine.util.CustomClasspathLocation;
import game.engine.util.LWJGLException;
import game.engine.util.LWJGLInstaller;
import game.engine.util.OperatingSystem;
import java.io.File;
import javax.swing.JOptionPane;
import org.newdawn.slick.AppGameContainer;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.opengl.renderer.Renderer;
import org.newdawn.slick.state.StateBasedGame;
import org.newdawn.slick.util.ResourceLoader;

public class MyTinyWorld
extends StateBasedGame {
    private static boolean developerMode = false;
    private static boolean benchmarkMode = false;
    private static boolean skipInstall = false;

    public MyTinyWorld() {
        super("Last World - A Ludum Dare #23 game");
        ResourceLoader.addResourceLocation(new CustomClasspathLocation());
        Renderer.setRenderer(2);
    }

    public void initStatesList(GameContainer container) throws SlickException {
        if (!developerMode) {
            container.setShowFPS(false);
        }
        if (!benchmarkMode) {
            container.setTargetFrameRate(60);
        }
        this.addState(new MyTinyWorldTitle());
        this.addState(new MyTinyWorldGame());
        this.addState(new MyTinyWorldGameOver());
    }

    public static void main(String[] args) throws SlickException {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("--dev")) {
                developerMode = true;
                continue;
            }
            if (args[i].equals("--bench")) {
                benchmarkMode = true;
                continue;
            }
            if (!args[i].equals("--skipinstall")) continue;
            skipInstall = true;
        }
        if (!skipInstall && !MyTinyWorld.setupNativeLibraries()) {
            System.exit(0);
        }
        MyTinyWorld game = new MyTinyWorld();
        AppGameContainer gameContainer = new AppGameContainer(game, 800, 600, false);
        if (!benchmarkMode) {
            gameContainer.setTargetFrameRate(60);
        }
        if (!developerMode) {
            gameContainer.setShowFPS(false);
        }
        gameContainer.start();
    }

    public static boolean isDeveloperMode() {
        return developerMode;
    }

    private static boolean setupNativeLibraries() {
        File gameDir = new File(System.getProperty("user.home"), MyTinyWorld.class.getSimpleName());
        LWJGLInstaller installer = new LWJGLInstaller(gameDir);
        installer.setOperatingSystemArchive(OperatingSystem.windows, "/natives/windows_natives.jar");
        installer.setOperatingSystemArchive(OperatingSystem.linux, "/natives/linux_natives.jar");
        installer.setOperatingSystemArchive(OperatingSystem.macosx, "/natives/maxosx_natives.jar");
        installer.setOperatingSystemArchive(OperatingSystem.solaris, "/natives/solaris_natives.jar");
        OperatingSystem os = OperatingSystem.getCurrentOperatingSystem();
        if (os == null) {
            os = (OperatingSystem)((Object)JOptionPane.showInputDialog(null, "Your operating system could not be detected.\nPlease choose the closest match below.", "Cannot detect operating system", 1, null, (Object[])OperatingSystem.values(), (Object)OperatingSystem.windows));
        }
        if (os == null) {
            return false;
        }
        try {
            installer.install(os);
            return true;
        }
        catch (LWJGLException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, "Could not install native libraries.\n" + e.getMessage());
            return false;
        }
    }
}

