/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.CollisionAdapter;
import game.MyTinyWorldState;
import game.engine.loader.EntityLoader;
import game.engine.util.ImageUtil;
import game.entities.ArenaBounds;
import game.entities.BlackHole;
import game.entities.BlackHoleSpawner;
import game.entities.CollisionSoundEntity;
import game.entities.Entity;
import game.entities.Flare;
import game.entities.FlareSpawner;
import game.entities.GravityEntity;
import game.entities.Meteorite;
import game.entities.MeteoriteSpawner;
import game.entities.Moon;
import game.entities.MoonSpawner;
import game.entities.ParticleProvider;
import game.entities.PhysicsEntity;
import game.entities.Planet;
import game.entities.PlanetSpawner;
import game.entities.PlayerPlanet;
import game.entities.Sun;
import game.entities.WaveSpawner;
import game.world.GameWorld;
import org.jbox2d.dynamics.contacts.Contact;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.Image;
import org.newdawn.slick.Music;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.geom.Vector2f;
import org.newdawn.slick.state.BasicGameState;
import org.newdawn.slick.state.StateBasedGame;

public class MyTinyWorldGame
extends BasicGameState {
    private static final float ARROW_MARGIN = 40.0f;
    private GameWorld world;
    private EntityLoader loader;
    private Image findArrow;
    private Image vignette;
    private PlayerPlanet playerPlanet;
    private boolean active;
    private Music gameMusic;
    private Entity soundPlayer;
    private long updateTime;

    public void init(GameContainer container, StateBasedGame game) throws SlickException {
        this.gameMusic = new Music("/assets/audio/main_game_beat.ogg", true);
        Image cursor = ImageUtil.load("/assets/graphics/cursor.png");
        container.setMouseCursor(cursor, 0, 0);
        this.findArrow = ImageUtil.load("/assets/graphics/find_arrow.png");
        this.vignette = ImageUtil.load("/assets/graphics/vignette.png");
        this.loader = new EntityLoader("/assets/xml");
        this.world = new GameWorld(this.loader);
        this.world.getEntities().installTypeMapping(PhysicsEntity.class);
        this.world.getEntities().installTypeMapping(GravityEntity.class);
        this.world.getEntities().installTypeMapping(PlayerPlanet.class);
        this.world.getEntities().installTypeMapping(ArenaBounds.class);
        this.world.getEntities().installTypeMapping(ParticleProvider.class);
        this.world.getEntities().installTypeMapping(Moon.class);
        this.world.getCamera().init(container.getWidth(), container.getHeight());
        this.registerCollisionHandlers();
        this.world.getEntities().add(this.world.getLoader().create("particleprovider"));
        this.world.getEntities().add(this.world.getLoader().create("sun"));
        this.playerPlanet = (PlayerPlanet)this.world.getLoader().create("playerplanet");
        this.playerPlanet.setPos(0.0f, -1500.0f);
        this.world.getCamera().attach(this.playerPlanet);
        this.world.getEntities().add(this.playerPlanet);
        this.world.getEntities().add(this.world.getLoader().create("collisionsound"));
        this.world.setSoundPlayer((CollisionSoundEntity)this.world.getLoader().create("collisionsound"));
        this.world.getEntities().add(this.world.getLoader().create("tutorial"));
        this.world.getEntities().add(this.world.getLoader().create("hud"));
        ArenaBounds arenaBounds = (ArenaBounds)this.world.getLoader().create("arenabounds");
        this.world.getEntities().add(arenaBounds);
        WaveSpawner waveSpawner = (WaveSpawner)this.world.getLoader().create("wavespawner");
        this.world.getEntities().add(waveSpawner);
        MeteoriteSpawner meteoriteSpawner = (MeteoriteSpawner)this.world.getLoader().create("meteoritespawner");
        this.world.getEntities().add(meteoriteSpawner);
        MoonSpawner moonSpawner = (MoonSpawner)this.world.getLoader().create("moonspawner");
        this.world.getEntities().add(moonSpawner);
        PlanetSpawner planetSpawner = (PlanetSpawner)this.world.getLoader().create("planetspawner");
        this.world.getEntities().add(planetSpawner);
        FlareSpawner flareSpawner = (FlareSpawner)this.world.getLoader().create("flarespawner");
        this.world.getEntities().add(flareSpawner);
        BlackHoleSpawner blackHoleSpawner = (BlackHoleSpawner)this.world.getLoader().create("blackholespawner");
        this.world.getEntities().add(blackHoleSpawner);
        BlackHole hole = (BlackHole)this.world.getLoader().create("blackhole");
        hole.setPos(-1000.0f, 100.0f);
        for (int i = 0; i < 10; ++i) {
            Moon moon = (Moon)this.world.getLoader().create("moon");
            moon.setPos(1000.0f, 1000.0f * (float)(i - 5));
            this.world.getEntities().add(moon);
        }
        this.active = false;
    }

    public void enter(GameContainer container, StateBasedGame game) throws SlickException {
        super.enter(container, game);
        this.active = true;
        this.gameMusic.loop(1.0f, 0.3f);
    }

    public void leave(GameContainer container, StateBasedGame game) throws SlickException {
        super.leave(container, game);
        this.gameMusic.fade(1000, 0.0f, true);
    }

    private void registerCollisionHandlers() {
        this.world.getCollisionManager().registerHandler(Flare.class, Entity.class, new CollisionAdapter<Flare, Entity>(){

            @Override
            public void beginContact(GameWorld world, Flare a, Entity b, Contact c) {
                if (!(b instanceof Flare)) {
                    if (a.getBody() != null) {
                        world.collisionSound(MyTinyWorldGame.this.playerPlanet.getBody().getPosition().sub(a.getBody().getPosition()).length());
                    }
                    if (b instanceof Planet) {
                        ((Planet)b).applyDamage(a.getDestruction(), world);
                    }
                    Vector2f dir = new Vector2f(b.getPos().x - a.getPos().x, b.getPos().y - a.getPos().y).normalise();
                    MyTinyWorldGame.this.spawnExplosion(a.getPos(), dir);
                    a.despawn(world);
                }
            }
        });
        this.world.getCollisionManager().registerHandler(BlackHole.class, Entity.class, new CollisionAdapter<BlackHole, Entity>(){

            @Override
            public void beginContact(GameWorld world, BlackHole a, Entity b, Contact c) {
                if (b instanceof PlayerPlanet) {
                    if (a.getBody() != null && b.getBody() != null) {
                        world.collisionSound(MyTinyWorldGame.this.playerPlanet.getBody().getPosition().sub(a.getBody().getPosition()).length());
                    }
                    ((PlayerPlanet)b).applyDamage(2.1474836E9f, world);
                } else {
                    if (a.getBody() != null && b.getBody() != null) {
                        world.collisionSound(MyTinyWorldGame.this.playerPlanet.getBody().getPosition().sub(a.getBody().getPosition()).length());
                    }
                    world.getEntities().remove(b);
                }
            }
        });
        this.world.getCollisionManager().registerHandler(Sun.class, Sun.class, new CollisionAdapter<Sun, Sun>(){

            @Override
            public void beginContact(GameWorld world, Sun a, Sun b, Contact c) {
                if (a.getBody() != null && b.getBody() != null) {
                    world.collisionSound(MyTinyWorldGame.this.playerPlanet.getBody().getPosition().sub(a.getBody().getPosition()).length());
                }
                world.getEntities().remove(a);
                world.getEntities().remove(b);
            }
        });
        this.world.getCollisionManager().registerHandler(Sun.class, Planet.class, new CollisionAdapter<Sun, Planet>(){

            @Override
            public void beginContact(GameWorld world, Sun a, Planet b, Contact c) {
                if (a.getBody() != null && b.getBody() != null) {
                    world.collisionSound(MyTinyWorldGame.this.playerPlanet.getBody().getPosition().sub(a.getBody().getPosition()).length());
                }
                b.applyDamage(2.1474836E9f, world);
            }
        });
        this.world.getCollisionManager().registerHandler(Meteorite.class, Sun.class, new CollisionAdapter<Meteorite, Sun>(){

            @Override
            public void beginContact(GameWorld world, Meteorite a, Sun b, Contact c) {
                if (a.getBody() != null && b.getBody() != null) {
                    world.collisionSound(MyTinyWorldGame.this.playerPlanet.getBody().getPosition().sub(a.getBody().getPosition()).length());
                }
                b.addCollisionParticles(a.getPos());
                world.getEntities().remove(a);
            }
        });
        this.world.getCollisionManager().registerHandler(Sun.class, Moon.class, new CollisionAdapter<Sun, Moon>(){

            @Override
            public void beginContact(GameWorld world, Sun a, Moon b, Contact c) {
                if (a.getBody() != null && b.getBody() != null) {
                    world.collisionSound(MyTinyWorldGame.this.playerPlanet.getBody().getPosition().sub(a.getBody().getPosition()).length());
                }
                world.getEntities().remove(b);
            }
        });
        this.world.getCollisionManager().registerHandler(Planet.class, Meteorite.class, new CollisionAdapter<Planet, Meteorite>(){

            @Override
            public void beginContact(GameWorld world, Planet a, Meteorite b, Contact c) {
                if (a.getBody() != null && b.getBody() != null) {
                    world.collisionSound(MyTinyWorldGame.this.playerPlanet.getBody().getPosition().sub(a.getBody().getPosition()).length());
                }
                world.getEntities().remove(b);
                a.applyDamage(b.getDestruction(), world);
            }
        });
        this.world.getCollisionManager().registerHandler(Planet.class, Moon.class, new CollisionAdapter<Planet, Moon>(){

            @Override
            public void beginContact(GameWorld world, Planet a, Moon b, Contact c) {
                if (a.getBody() != null && b.getBody() != null) {
                    world.collisionSound(MyTinyWorldGame.this.playerPlanet.getBody().getPosition().sub(a.getBody().getPosition()).length());
                }
                world.getEntities().remove(b);
            }
        });
        this.world.getCollisionManager().registerHandler(Meteorite.class, Moon.class, new CollisionAdapter<Meteorite, Moon>(){

            @Override
            public void beginContact(GameWorld world, Meteorite a, Moon b, Contact c) {
                if (a.getBody() != null && b.getBody() != null) {
                    world.collisionSound(MyTinyWorldGame.this.playerPlanet.getBody().getPosition().sub(a.getBody().getPosition()).length());
                }
                world.getEntities().remove(b);
            }
        });
        this.world.getCollisionManager().registerHandler(Flare.class, Meteorite.class, new CollisionAdapter<Flare, Meteorite>(){

            @Override
            public void beginContact(GameWorld world, Flare a, Meteorite b, Contact c) {
                if (a.getBody() != null) {
                    world.collisionSound(MyTinyWorldGame.this.playerPlanet.getBody().getPosition().sub(a.getBody().getPosition()).length());
                }
                world.getEntities().remove(b);
            }
        });
        this.world.getCollisionManager().registerHandler(Planet.class, Planet.class, new CollisionAdapter<Planet, Planet>(){

            @Override
            public void beginContact(GameWorld world, Planet a, Planet b, Contact c) {
                if (a.getBody() != null && b.getBody() != null) {
                    world.collisionSound(MyTinyWorldGame.this.playerPlanet.getBody().getPosition().sub(a.getBody().getPosition()).length());
                }
                if (a instanceof PlayerPlanet) {
                    a.applyDamage(2.5f, world);
                } else {
                    world.getEntities().remove(a);
                }
                if (b instanceof PlayerPlanet) {
                    b.applyDamage(2.5f, world);
                } else {
                    world.getEntities().remove(b);
                }
            }
        });
        this.world.getCollisionManager().registerHandler(Flare.class, Moon.class, new CollisionAdapter<Flare, Moon>(){

            @Override
            public void beginContact(GameWorld world, Flare a, Moon b, Contact c) {
                if (a.getBody() != null) {
                    world.collisionSound(MyTinyWorldGame.this.playerPlanet.getBody().getPosition().sub(a.getBody().getPosition()).length());
                }
                world.getEntities().remove(b);
            }
        });
    }

    protected void spawnExplosion(Vector2f pos, Vector2f dir) {
        ParticleProvider pp = this.world.getEntities().getOne(ParticleProvider.class);
        pp.spawnEmitter("suncollision_emitter", pos, dir);
    }

    public void render(GameContainer container, StateBasedGame game, Graphics g) throws SlickException {
        if (!this.active) {
            this.update(container, game, 100);
            this.active = true;
        }
        g.pushTransform();
        this.world.render(g, container);
        g.popTransform();
        g.drawImage(this.vignette, 0.0f, 0.0f);
    }

    public void update(GameContainer container, StateBasedGame game, int dt) throws SlickException {
        this.world.update(dt, container);
        if (this.playerPlanet.isDestroyed()) {
            game.enterState(MyTinyWorldState.gameover.ordinal());
        }
    }

    public int getID() {
        return MyTinyWorldState.game.ordinal();
    }
}

