/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.MyTinyWorldState;
import game.engine.util.ImageUtil;
import org.newdawn.slick.Color;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.Image;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.state.BasicGameState;
import org.newdawn.slick.state.StateBasedGame;

public class MyTinyWorldGameOver
extends BasicGameState {
    private Image gameOverImage;

    public void init(GameContainer container, StateBasedGame game) throws SlickException {
        this.gameOverImage = ImageUtil.load("/assets/graphics/game_over_screen.png");
    }

    public void update(GameContainer container, StateBasedGame game, int delta) throws SlickException {
        if (container.getInput().isKeyPressed(28)) {
            game.enterState(MyTinyWorldState.title.ordinal());
        }
    }

    public void render(GameContainer container, StateBasedGame game, Graphics g) throws SlickException {
        g.pushTransform();
        this.gameOverImage.draw(0.0f, 0.0f, (float)container.getWidth(), container.getHeight());
        String text = "Press return to go back to the title screen...";
        int textWidth = g.getFont().getWidth(text);
        int textHeight = g.getFont().getHeight(text);
        g.translate((float)container.getWidth() / 2.0f, container.getHeight());
        g.setColor(Color.white);
        g.drawString(text, (float)(-textWidth) / 2.0f, -textHeight - g.getFont().getLineHeight());
        g.popTransform();
    }

    public int getID() {
        return MyTinyWorldState.gameover.ordinal();
    }
}

