/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.MyTinyWorldState;
import game.engine.util.ImageUtil;
import org.newdawn.slick.Color;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.Image;
import org.newdawn.slick.Music;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.Sound;
import org.newdawn.slick.state.BasicGameState;
import org.newdawn.slick.state.StateBasedGame;
import org.newdawn.slick.state.transition.FadeInTransition;
import org.newdawn.slick.state.transition.FadeOutTransition;

public class MyTinyWorldTitle
extends BasicGameState {
    private static final String[] OPTIONS = new String[]{"Start game", "About", "Exit game"};
    private MenuOption currentOption;
    private TitleState state;
    private Image titleImage;
    private Music titleMusic;
    private Sound titleSound;

    public void init(GameContainer container, StateBasedGame game) throws SlickException {
        this.currentOption = MenuOption.start;
        this.state = TitleState.menu;
        this.titleImage = ImageUtil.load("/assets/graphics/title_screen.png");
        this.titleMusic = new Music("/assets/audio/last_world_intro.ogg", true);
        this.titleSound = new Sound("/assets/audio/start_1.ogg");
    }

    public void enter(GameContainer container, StateBasedGame game) throws SlickException {
        super.enter(container, game);
        this.currentOption = MenuOption.start;
        this.state = TitleState.menu;
        this.titleMusic.loop();
    }

    public void leave(GameContainer container, StateBasedGame game) throws SlickException {
        super.leave(container, game);
        this.titleMusic.fade(1000, 0.0f, true);
    }

    public void update(GameContainer container, StateBasedGame game, int delta) throws SlickException {
        if (this.state == TitleState.menu) {
            if (container.getInput().isKeyPressed(28)) {
                switch (this.currentOption) {
                    case start: {
                        this.titleSound.play();
                        game.getState(MyTinyWorldState.game.ordinal()).init(container, game);
                        game.enterState(MyTinyWorldState.game.ordinal(), new FadeOutTransition(Color.black, 1000), new FadeInTransition(Color.black, 1000));
                        break;
                    }
                    case about: {
                        this.state = TitleState.about;
                        this.titleSound.play();
                        break;
                    }
                    case exit: {
                        System.exit(0);
                    }
                }
            } else if (container.getInput().isKeyPressed(208)) {
                int i = Math.min(MenuOption.values().length - 1, this.currentOption.ordinal() + 1);
                this.currentOption = MenuOption.values()[i];
                this.titleSound.play();
            } else if (container.getInput().isKeyPressed(200)) {
                int i = Math.max(0, this.currentOption.ordinal() - 1);
                this.currentOption = MenuOption.values()[i];
                this.titleSound.play();
            }
        } else if (this.state == TitleState.about && container.getInput().isKeyPressed(28)) {
            this.state = TitleState.menu;
            this.titleSound.play();
        }
    }

    public void render(GameContainer container, StateBasedGame game, Graphics g) throws SlickException {
        g.pushTransform();
        if (this.state == TitleState.menu) {
            this.titleImage.draw(0.0f, -100.0f, (float)container.getWidth(), container.getHeight());
            float y = (float)container.getHeight() - 150.0f;
            for (int i = 0; i < OPTIONS.length; ++i) {
                String text = i == this.currentOption.ordinal() ? "> " + OPTIONS[i] + " <" : OPTIONS[i];
                int textWidth = g.getFont().getWidth(text);
                g.setColor(Color.white);
                g.drawString(text, (float)container.getWidth() / 2.0f - (float)textWidth / 2.0f, y);
                y += (float)g.getFont().getLineHeight();
            }
        } else if (this.state == TitleState.about) {
            this.titleImage.draw(0.0f, -100.0f, (float)container.getWidth(), container.getHeight());
            StringBuilder sb = new StringBuilder();
            sb.append("This game was made during 72 hours for the Ludum Dare #23 jam.\nThe development team consisted of: \n* Simeon Atanasov - Graphics and sound\n* Cem Eliy\u00fcrekli - Programmer\n* Einar Holst - Programmer\n* John David Olovsson - Programmer\n* Marcus Wennermark - Programmer and coffee maker");
            int w = g.getFont().getWidth(sb.toString());
            int h = g.getFont().getHeight(sb.toString());
            g.setColor(Color.white);
            g.drawString(sb.toString(), (float)container.getWidth() / 2.0f - (float)w / 2.0f, container.getHeight() - h - g.getFont().getLineHeight());
        }
        g.popTransform();
    }

    public int getID() {
        return MyTinyWorldState.title.ordinal();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum MenuOption {
        start,
        about,
        exit;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TitleState {
        menu,
        about;

    }
}

