/*
 * Decompiled with CFR 0.152.
 */
package game.engine;

import game.engine.BoundingBox;
import game.entities.Entity;
import game.world.GameWorld;
import org.jbox2d.common.Vec2;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.geom.Vector2f;

public class GameCamera {
    private static final float MAX_SPEED_OFFSET = 175.0f;
    private static final float MAX_SCALE_SPEED = 8.0f;
    private static final float MIN_SCALE = 0.3f;
    private static final float MAX_SCALE = 0.5f;
    private Entity stalked;
    private float scale = 1.0f;
    private BoundingBox screenBounds;
    private Vector2f screenPos = new Vector2f(0.0f, 0.0f);

    public void setScale(float scale) {
        this.scale = scale;
    }

    public float getScale() {
        return this.scale;
    }

    public void attach(Entity stalked) {
        this.stalked = stalked;
    }

    public void init(int screenWidth, int screenHeight) {
        this.screenPos = new Vector2f(0.0f, 0.0f);
        this.screenBounds = new BoundingBox((float)(-screenWidth) / this.scale / 2.0f, (float)(-screenHeight) / this.scale / 2.0f, (float)screenWidth / this.scale, (float)screenHeight / this.scale);
    }

    public void update(GameWorld world, int dt) {
        if (this.stalked != null && this.stalked.getBody() != null) {
            Vec2 dir = this.stalked.getBody().getLinearVelocity().clone();
            float speed = dir.length();
            dir.normalize();
            Vector2f pos = this.stalked.getPos();
            float normalizedSpeed = Math.min(1.0f, speed / 8.0f);
            float scale = (1.0f - normalizedSpeed) * 0.19999999f + 0.3f;
            dir = dir.mul((float)(Math.pow(normalizedSpeed, 1.0) * 175.0 / (double)scale));
            this.setScale(scale);
            this.updateBounds(800, 600);
            this.screenPos.set(pos.x + dir.x, pos.y + dir.y);
        }
    }

    private void updateBounds(int screenWidth, int screenHeight) {
        this.screenBounds = new BoundingBox((float)(-screenWidth) / this.scale / 2.0f, (float)(-screenHeight) / this.scale / 2.0f, (float)screenWidth / this.scale, (float)screenHeight / this.scale);
    }

    public BoundingBox getScreenBounds() {
        if (this.screenBounds == null) {
            return new BoundingBox(0.0f, 0.0f, 0.0f, 0.0f);
        }
        return this.screenBounds;
    }

    public Vector2f getScreenPos() {
        return this.screenPos;
    }

    public void applyTransform(Graphics g, GameContainer container) {
        g.translate((float)container.getWidth() / 2.0f, (float)container.getHeight() / 2.0f);
        g.scale(this.scale, this.scale);
        g.translate(-Math.round(this.screenPos.x), -Math.round(this.screenPos.y));
    }

    public void applyInverseTransform(Graphics g, GameContainer container) {
        g.translate(Math.round(this.screenPos.x), Math.round(this.screenPos.y));
        g.scale(1.0f / this.scale, 1.0f / this.scale);
        g.translate((float)(-container.getWidth()) / 2.0f, (float)(-container.getHeight()) / 2.0f);
    }
}

