/*
 * Decompiled with CFR 0.152.
 */
package game.engine.loader;

import org.newdawn.slick.SlickException;
import org.newdawn.slick.util.xml.SlickXMLException;
import org.newdawn.slick.util.xml.XMLElement;
import org.newdawn.slick.util.xml.XMLElementList;
import org.newdawn.slick.util.xml.XMLParser;

class AssetXMLLoader {
    public AssetXMLLoader(String file, String rootNodeName, String childNodeName, Handler handler) throws SlickException {
        XMLParser parser = new XMLParser();
        String fileFix = file.replaceAll("\\\\", "/");
        XMLElement root = parser.parse(fileFix, this.getClass().getResourceAsStream(fileFix));
        if (root.getName().equals(rootNodeName)) {
            XMLElementList nodeList = root.getChildren();
            for (int i = 0; i < nodeList.size(); ++i) {
                XMLElement node = nodeList.get(i);
                if (!node.getName().equals(childNodeName)) {
                    throw new SlickXMLException("Invalid node '" + node.getName() + "'. Expecting a '" + childNodeName + "' node.");
                }
                handler.handle(node);
            }
        } else {
            throw new SlickXMLException("Invalid document root node '" + root.getName() + "'. Expecting a '" + rootNodeName + "' node.");
        }
    }

    public static interface Handler {
        public void handle(XMLElement var1) throws SlickException;
    }
}

