/*
 * Decompiled with CFR 0.152.
 */
package game.engine.util;

import game.engine.util.ObjectListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectManager<T> {
    private Class<T> baseType;
    private Map<Class<? extends T>, List<T>> typeMappings;
    private ArrayList<ObjectListener<T>> listeners;

    public ObjectManager(Class<T> baseType) {
        this.baseType = baseType;
        this.typeMappings = new HashMap<Class<? extends T>, List<T>>();
        this.typeMappings.put(baseType, new ArrayList());
        this.listeners = new ArrayList();
    }

    public void add(T object) {
        for (Map.Entry<Class<T>, List<T>> entry : this.typeMappings.entrySet()) {
            if (!entry.getKey().isAssignableFrom(object.getClass())) continue;
            entry.getValue().add(object);
        }
        for (ObjectListener objectListener : this.listeners) {
            objectListener.onAdd(object);
        }
    }

    public void remove(T object) {
        for (Map.Entry<Class<T>, List<T>> entry : this.typeMappings.entrySet()) {
            if (!entry.getKey().isAssignableFrom(object.getClass())) continue;
            entry.getValue().remove(object);
        }
        for (ObjectListener objectListener : this.listeners) {
            objectListener.onRemove(object);
        }
    }

    public <V extends T> List<V> get(Class<V> type) {
        if (this.typeMappings.containsKey(type)) {
            ArrayList<V> ret = new ArrayList<V>();
            for (T object : this.typeMappings.get(type)) {
                ret.add(type.cast(object));
            }
            return ret;
        }
        ArrayList<V> ret = new ArrayList<V>();
        for (T object : this.typeMappings.get(this.baseType)) {
            if (!type.isAssignableFrom(object.getClass())) continue;
            ret.add(type.cast(object));
        }
        return ret;
    }

    public <V extends T> V getOne(Class<V> type) {
        if (this.typeMappings.containsKey(type)) {
            if (this.typeMappings.get(type).isEmpty()) {
                return null;
            }
            return type.cast(this.typeMappings.get(type).get(0));
        }
        for (T object : this.typeMappings.get(this.baseType)) {
            if (!type.isAssignableFrom(object.getClass())) continue;
            return type.cast(object);
        }
        return null;
    }

    public List<T> get() {
        return new ArrayList(this.typeMappings.get(this.baseType));
    }

    public void installTypeMapping(Class<? extends T> type) {
        ArrayList<T> objects = new ArrayList<T>();
        for (T object : this.typeMappings.get(this.baseType)) {
            if (!type.isAssignableFrom(object.getClass())) continue;
            objects.add(type.cast(object));
        }
        this.typeMappings.put(type, objects);
    }

    public void addListener(ObjectListener<T> listener) {
        this.listeners.add(listener);
    }

    public T get(T object) {
        for (Map.Entry<Class<T>, List<T>> typeMapping : this.typeMappings.entrySet()) {
            if (!typeMapping.getKey().isAssignableFrom(object.getClass())) continue;
            return object;
        }
        return null;
    }

    public int size() {
        return this.typeMappings.get(this.baseType).size();
    }
}

