/*
 * Decompiled with CFR 0.152.
 */
package game.entities;

import game.engine.loader.EntityDescriptor;
import game.entities.GravityEntity;
import game.world.GameWorld;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.BodyDef;
import org.jbox2d.dynamics.BodyType;
import org.jbox2d.dynamics.joints.DistanceJointDef;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.particles.ConfigurableEmitter;
import org.newdawn.slick.particles.ParticleSystem;

public class BlackHole
extends GravityEntity {
    private Body anchorBody;
    private ParticleSystem blackHoleParticles;
    private ConfigurableEmitter matterEmitter1;
    private ConfigurableEmitter matterEmitter2;

    public BlackHole(EntityDescriptor descriptor) {
        super(descriptor);
        this.currentState = "blackhole";
        this.matterEmitter1 = descriptor.particleEmitters.get("blackhole_emitter1").duplicate();
        this.matterEmitter2 = descriptor.particleEmitters.get("blackhole_emitter2").duplicate();
        this.blackHoleParticles = new ParticleSystem("/assets/graphics/default_particle.png", 150);
        this.blackHoleParticles.addEmitter(this.matterEmitter1);
        this.blackHoleParticles.addEmitter(this.matterEmitter2);
    }

    public void init(GameWorld world) {
        super.init(world);
        BodyDef bodyDef = new BodyDef();
        bodyDef.type = BodyType.STATIC;
        bodyDef.position = new Vec2(this.getPos().x / 100.0f, this.getPos().y / 100.0f);
        this.anchorBody = world.getPhysicsWorld().createBody(bodyDef);
        DistanceJointDef def = new DistanceJointDef();
        def.initialize(this.body, this.anchorBody, this.body.getWorldCenter(), this.anchorBody.getWorldCenter());
        def.length = 0.0f;
        def.dampingRatio = 0.9f;
        world.getPhysicsWorld().createJoint(def);
    }

    public void update(int dt, GameWorld world, GameContainer container) {
        super.update(dt, world, container);
        this.blackHoleParticles.update(dt);
    }

    public void render(Graphics g, GameWorld world, GameContainer container) {
        this.blackHoleParticles.render();
        super.render(g, world, container);
    }

    public void destroy(GameWorld world) {
        super.destroy(world);
        if (this.anchorBody != null) {
            world.requestBodyDestruction(this.anchorBody);
            this.anchorBody = null;
        }
    }
}

