/*
 * Decompiled with CFR 0.152.
 */
package game.entities;

import game.engine.loader.EntityDescriptor;
import game.entities.ArenaBounds;
import game.entities.Entity;
import game.world.GameWorld;
import java.util.Iterator;
import java.util.LinkedList;
import org.jbox2d.common.Vec2;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.particles.ConfigurableEmitter;
import org.newdawn.slick.particles.ParticleSystem;

public class BlackHoleSpawner
extends Entity {
    private ParticleSystem warningParticles;
    private ConfigurableEmitter warningEmitter;
    private static final int WARNING_BEFORE_SPAWN_DURATION = 3000;
    private int spawnTick;
    private int spawnTickStep;
    private int currentDuration;
    LinkedList<BlackHoleStruct> blackHoles = new LinkedList();
    LinkedList<Warning> warnings = new LinkedList();

    public BlackHoleSpawner(EntityDescriptor descriptor) {
        super(descriptor);
        this.setSpawnTickStep(2000);
        this.setDuration(5000);
        this.warningEmitter = descriptor.particleEmitters.get("warning_emitter").duplicate();
        this.warningParticles = new ParticleSystem("/assets/graphics/default_particle.png", 150);
        this.warningParticles.setRemoveCompletedEmitters(true);
    }

    public boolean preRender(Graphics g, GameWorld world, GameContainer container) {
        return true;
    }

    public void postRender(Graphics g, GameWorld world, GameContainer container) {
    }

    public void update(int dt, GameWorld world, GameContainer container) {
        super.update(dt, world, container);
        this.warningParticles.update(dt);
        this.spawnTick += dt;
        if (this.spawnTick >= this.spawnTickStep) {
            ConfigurableEmitter emitter;
            this.spawnTick = 0;
            float halfArenaRadius = world.getEntities().getOne(ArenaBounds.class).getArenaRadius() * 0.5f;
            float spawnRadius = (float)((double)halfArenaRadius * (1.0 + 0.3 * (double)world.getRandom().nextFloat()));
            Vec2 spawnPosition = new Vec2();
            spawnPosition.x = 2.0f * world.getRandom().nextFloat() - 1.0f;
            spawnPosition.y = 2.0f * world.getRandom().nextFloat() - 1.0f;
            spawnPosition.normalize();
            spawnPosition = spawnPosition.mul(spawnRadius);
            Warning newWarning = new Warning(spawnPosition);
            this.warnings.add(newWarning);
            newWarning.emitter = emitter = this.warningEmitter.duplicate();
            emitter.setPosition(newWarning.spawnPosition.x * 100.0f, newWarning.spawnPosition.y * 100.0f);
            this.warningParticles.addEmitter(emitter);
        }
        Iterator itr = this.blackHoles.iterator();
        while (itr.hasNext()) {
            BlackHoleStruct bhs = (BlackHoleStruct)itr.next();
            bhs.ticker += dt;
            if (bhs.ticker <= bhs.duration) continue;
            world.getEntities().remove(bhs.hole);
            itr.remove();
        }
        Iterator itrW = this.warnings.iterator();
        while (itrW.hasNext()) {
            Warning warning = (Warning)itrW.next();
            warning.ticker += dt;
            if (warning.ticker < 3000) continue;
            this.spawn(world, warning.spawnPosition);
            warning.emitter.setEnabled(false);
            itrW.remove();
        }
    }

    public void setSpawnTickStep(int spawnTickStep) {
        this.spawnTickStep = spawnTickStep;
    }

    private void spawn(GameWorld world, Vec2 spawnPosition) {
        Entity blackHole = world.getLoader().create("blackhole");
        blackHole.setPos(spawnPosition.x * 100.0f, spawnPosition.y * 100.0f);
        world.getEntities().add(blackHole);
        blackHole.getBody().setTransform(spawnPosition, blackHole.getBody().getAngle());
        this.blackHoles.add(new BlackHoleStruct(blackHole, this.currentDuration));
    }

    public void setDuration(int duration) {
        this.currentDuration = duration;
    }

    public void render(Graphics g, GameWorld world, GameContainer container) {
        this.warningParticles.render();
        super.render(g, world, container);
    }

    private class Warning {
        public int ticker;
        public Vec2 spawnPosition;
        public ConfigurableEmitter emitter;

        public Warning(Vec2 spawnPosition) {
            this.spawnPosition = spawnPosition;
        }
    }

    private class BlackHoleStruct {
        public Entity hole;
        public int ticker;
        public int duration;

        public BlackHoleStruct(Entity hole, int duration) {
            this.hole = hole;
            this.ticker = 0;
            this.duration = duration;
        }
    }
}

