/*
 * Decompiled with CFR 0.152.
 */
package game.entities;

import game.engine.BoundingBox;
import game.engine.loader.AssetStore;
import game.engine.loader.EntityDescriptor;
import game.engine.loader.PropertyStore;
import game.world.GameWorld;
import java.util.List;
import org.jbox2d.collision.shapes.PolygonShape;
import org.jbox2d.collision.shapes.Shape;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.BodyDef;
import org.jbox2d.dynamics.Fixture;
import org.jbox2d.dynamics.FixtureDef;
import org.newdawn.slick.Animation;
import org.newdawn.slick.Color;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.geom.Vector2f;
import org.newdawn.slick.openal.Audio;
import org.newdawn.slick.particles.ConfigurableEmitter;

public abstract class Entity {
    private static final int RENDER_BIN_DEFAULT = 0;
    private final int renderBin;
    private Vector2f pos;
    private float rotation;
    protected BoundingBox bounds;
    protected AssetStore<Animation> animations;
    protected String currentState;
    protected AssetStore<ConfigurableEmitter> emitters;
    protected AssetStore<Audio> audioMap;
    protected PropertyStore propertyMap;
    private BodyDef bodyDef;
    private List<FixtureDef> fixtureDefs;
    protected Body body;
    protected float scale;
    private final String name;
    protected boolean transformedRendering;
    protected boolean customRendering;

    public Entity(EntityDescriptor descriptor) {
        this.renderBin = descriptor.properties.getInt("renderbin", 0);
        this.name = descriptor.name;
        this.pos = new Vector2f(0.0f, 0.0f);
        this.rotation = 0.0f;
        this.bounds = descriptor.boundingBoxes.get("bounds");
        this.animations = descriptor.animations;
        this.currentState = "default";
        this.emitters = descriptor.particleEmitters;
        this.audioMap = descriptor.sounds;
        this.propertyMap = descriptor.properties;
        this.bodyDef = descriptor.body;
        this.fixtureDefs = descriptor.fixtures;
        this.scale = descriptor.scale;
        this.transformedRendering = true;
        this.customRendering = false;
    }

    public Vector2f getPos() {
        if (this.body != null) {
            Vec2 bodyPos = this.body.getPosition();
            this.pos.x = bodyPos.x * 100.0f;
            this.pos.y = bodyPos.y * 100.0f;
        }
        return this.pos;
    }

    public void init(GameWorld world) {
        if (this.bodyDef != null) {
            this.bodyDef.position = new Vec2(this.pos.x / 100.0f, this.pos.y / 100.0f);
            this.body = world.getPhysicsWorld().createBody(this.bodyDef);
            this.body.setUserData(this);
            for (FixtureDef fixtureDef : this.fixtureDefs) {
                this.body.createFixture(fixtureDef);
            }
        }
    }

    public void destroy(GameWorld world) {
        if (this.body != null) {
            world.requestBodyDestruction(this.body);
            this.body = null;
        }
    }

    public void update(int dt, GameWorld world, GameContainer container) {
        if (this.body != null) {
            Vec2 bodyPos = this.body.getPosition();
            this.pos.x = bodyPos.x * 100.0f;
            this.pos.y = bodyPos.y * 100.0f;
            this.rotation = (float)Math.toDegrees(this.body.getAngle());
        }
    }

    public int compareRenderOrder(Entity other) {
        return Integer.valueOf(this.renderBin).compareTo(other.renderBin);
    }

    public boolean preRender(Graphics g, GameWorld world, GameContainer container) {
        if (!this.customRendering && this.animations.isEmpty()) {
            return false;
        }
        BoundingBox screenBounds = world.getCamera().getScreenBounds();
        if (this.getBounds().intersects(this.pos, screenBounds, world.getCamera().getScreenPos())) {
            if (this.transformedRendering) {
                this.applyTransform(g);
            }
            return true;
        }
        return false;
    }

    public void render(Graphics g, GameWorld world, GameContainer container) {
        if (this.animations.contains(this.currentState)) {
            Animation animation = this.animations.get(this.currentState);
            g.drawAnimation(animation, (float)(-animation.getWidth()) / 2.0f, (float)(-animation.getHeight()) / 2.0f);
        }
    }

    public void postRender(Graphics g, GameWorld world, GameContainer container) {
        if (this.transformedRendering) {
            this.applyInverseTransform(g);
        }
    }

    protected void applyTransform(Graphics g) {
        g.translate(Math.round(this.pos.x), Math.round(this.pos.y));
        g.scale(this.scale, this.scale);
        g.rotate(0.0f, 0.0f, this.rotation);
    }

    protected void applyInverseTransform(Graphics g) {
        g.rotate(0.0f, 0.0f, -this.rotation);
        g.scale(1.0f / this.scale, 1.0f / this.scale);
        g.translate(-Math.round(this.pos.x), -Math.round(this.pos.y));
    }

    public void debug(Graphics g, GameWorld world, GameContainer container) {
        BoundingBox bounds = this.getBounds();
        if (bounds != null) {
            g.setColor(new Color(0.0f, 0.0f, 1.0f, 0.3f));
            g.fillRect(bounds.getMinX(this.pos), bounds.getMinY(this.pos), bounds.getWidth(), bounds.getHeight());
            g.setColor(Color.blue);
            g.drawRect(bounds.getMinX(this.pos), bounds.getMinY(this.pos), bounds.getWidth(), bounds.getHeight());
        }
        if (this.body != null) {
            float s = 100.0f;
            Vec2 p = this.body.getPosition();
            float theta = this.body.getAngle();
            g.pushTransform();
            g.translate(s * p.x, s * p.y);
            g.rotate(0.0f, 0.0f, (float)Math.toDegrees(theta));
            g.scale(s, s);
            block4: for (Fixture fixture = this.body.getFixtureList(); fixture != null; fixture = fixture.getNext()) {
                Shape shape = fixture.getShape();
                switch (shape.m_type) {
                    case CIRCLE: {
                        float r = shape.m_radius;
                        g.setColor(new Color(0.0f, 1.0f, 0.0f, 0.3f));
                        g.fillOval(-r, -r, r * 2.0f, r * 2.0f);
                        g.setColor(Color.green);
                        g.drawOval(-r, -r, r * 2.0f, r * 2.0f);
                        continue block4;
                    }
                    case POLYGON: {
                        PolygonShape poly = (PolygonShape)shape;
                        g.setColor(Color.green);
                        for (int i = 1; i < poly.getVertexCount() + 1; ++i) {
                            Vec2 v1 = poly.getVertex(i - 1);
                            Vec2 v2 = poly.getVertex(i % poly.getVertexCount());
                            g.drawLine(v1.x, v1.y, v2.x, v2.y);
                        }
                        continue block4;
                    }
                }
            }
            g.setColor(Color.red);
            g.drawLine(0.0f, 0.0f, 10.0f / s, 0.0f);
            g.setColor(Color.green);
            g.drawLine(0.0f, 0.0f, 0.0f, 10.0f / s);
            g.pushTransform();
            g.rotate(0.0f, 0.0f, -((float)Math.toDegrees(theta)));
            g.setColor(Color.magenta);
            g.drawLine(0.0f, 0.0f, this.body.getLinearVelocity().x, this.body.getLinearVelocity().y);
            g.popTransform();
            g.popTransform();
        }
        if (bounds != null) {
            g.pushTransform();
            g.translate(bounds.getMinX(this.pos), bounds.getMinY(this.pos));
            g.scale(2.0f, 2.0f);
            g.setColor(Color.red);
            g.drawString(this.name, 0.0f, 0.0f);
            if (this.body != null) {
                g.pushTransform();
                g.translate(0.0f, g.getFont().getLineHeight());
                g.scale(0.75f, 0.75f);
                StringBuilder sb = new StringBuilder();
                Vec2 p = this.body.getPosition();
                sb.append(String.format("Pos: (%5.3f,%5.3f)\n", Float.valueOf(p.x), Float.valueOf(p.y)));
                sb.append(String.format("Vel: %5.3f m/s\n", Float.valueOf(this.body.getLinearVelocity().length())));
                sb.append(String.format("Ang: %5.3f deg/s\n", Math.toDegrees(this.body.getAngularVelocity())));
                g.drawString(sb.toString(), 0.0f, 0.0f);
                g.popTransform();
            }
            g.popTransform();
        }
    }

    public BoundingBox getBounds() {
        return this.bounds;
    }

    public void playAudio(String name, float dist) {
        float gain = 1.0f - dist / 20.0f;
        gain = Math.max(gain, 0.0f);
        this.audioMap.get(name).playAsSoundEffect(1.0f, gain, false);
    }

    public String getProperty(String key, String def) {
        String value = (String)this.propertyMap.get(key);
        if (value == null) {
            value = def;
        }
        return value;
    }

    public void setPos(float x, float y) {
        this.pos.x = x;
        this.pos.y = y;
        if (this.body != null) {
            this.body.getPosition().set(x / 100.0f, y / 100.0f);
        }
    }

    public Body getBody() {
        return this.body;
    }

    public void setBody(Body body) {
        this.body = body;
    }
}

