/*
 * Decompiled with CFR 0.152.
 */
package game.entities;

import game.engine.BoundingBox;
import game.engine.loader.EntityDescriptor;
import game.entities.Moon;
import game.entities.PhysicsEntity;
import game.world.GameWorld;
import org.jbox2d.common.Vec2;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.geom.Vector2f;
import org.newdawn.slick.particles.ConfigurableEmitter;
import org.newdawn.slick.particles.ParticleSystem;

public class Flare
extends PhysicsEntity {
    private ParticleSystem flareParticles = new ParticleSystem("/assets/graphics/default_particle.png", 350);
    private ConfigurableEmitter flareEmitter;
    private static final int MAX_LIFETIME = 20000;
    private static final int DESTRUCTION_FORCE = 1;
    private int lifetime;
    private float supportedExtent;
    private int bufferedTime;

    public Flare(EntityDescriptor descriptor) {
        super(descriptor);
        this.flareEmitter = descriptor.particleEmitters.get("flare_emitter").duplicate();
        this.flareParticles.addEmitter(this.flareEmitter);
        this.supportedExtent = Math.min(this.getBounds().getWidth(), this.getBounds().getHeight()) / 2.0f;
        this.transformedRendering = false;
        this.customRendering = true;
        this.bufferedTime = 0;
    }

    public void update(int dt, GameWorld world, GameContainer container) {
        Vector2f sp;
        BoundingBox sb;
        super.update(dt, world, container);
        if (this.body == null) {
            if (this.flareParticles.getParticleCount() == 0) {
                world.getEntities().remove(this);
            }
        } else {
            this.lifetime += dt;
            if (this.lifetime >= 20000) {
                this.despawn(world);
            } else {
                Vec2 bodyPos = this.body.getWorldCenter().mul(100.0f);
                this.flareEmitter.setPosition(bodyPos.x, bodyPos.y);
                float speed = this.body.getLinearVelocity().length() * 100.0f;
                float maxLifeTime = this.flareEmitter.initialLife.getMax() / 1000.0f;
                float currentExtent = speed * maxLifeTime;
                if (currentExtent > this.supportedExtent || currentExtent < 0.5f * this.supportedExtent) {
                    this.supportedExtent = currentExtent * 1.2f;
                    this.bounds = new BoundingBox(-this.supportedExtent, -this.supportedExtent, 2.0f * this.supportedExtent, 2.0f * this.supportedExtent);
                }
            }
        }
        if ((sb = world.getCamera().getScreenBounds()).intersects(sp = world.getCamera().getScreenPos(), this.getBounds(), this.getPos())) {
            this.flareParticles.update(dt + this.bufferedTime);
            this.bufferedTime = 0;
        } else {
            this.bufferedTime += dt;
        }
    }

    public void render(Graphics g, GameWorld world, GameContainer container) {
        this.flareParticles.render();
    }

    public void despawn(GameWorld world) {
        if (this.body != null) {
            this.flareEmitter.setEnabled(false);
            world.requestBodyDestruction(this.body);
            this.body = null;
        }
    }

    public boolean doesCauseGravity() {
        return false;
    }

    public int getDestruction() {
        return 1;
    }

    public void laserDamage(GameWorld world, Moon moon, float x, float y) {
        this.despawn(world);
    }
}

