/*
 * Decompiled with CFR 0.152.
 */
package game.entities;

import game.engine.loader.EntityDescriptor;
import game.entities.Entity;
import game.entities.Sun;
import game.world.GameWorld;
import java.util.Iterator;
import org.jbox2d.common.Vec2;
import org.newdawn.slick.GameContainer;

public class FlareSpawner
extends Entity {
    private int tick;
    private int tickStep;
    private int spawnPerTick;
    private static final int TICKS_PER_IDLE_FLARE = 1000;
    private int idleFlareTicker;
    private float sunShotSpeed;

    public FlareSpawner(EntityDescriptor descriptor) {
        super(descriptor);
        this.setTickStep(700);
        this.setSpawnPerTick(4);
        this.setSunShotSpeed(7.5f);
    }

    public void update(int dt, GameWorld world, GameContainer container) {
        super.update(dt, world, container);
        this.tick += dt;
        this.idleFlareTicker += dt;
        if (this.idleFlareTicker >= 1000) {
            this.spawnSmallFlares(world);
            this.idleFlareTicker = 0;
        }
        if (this.tick >= this.tickStep) {
            this.tick = 0;
            this.spawn(world);
        }
    }

    public void setTickStep(int tickStep) {
        this.tickStep = tickStep;
    }

    public void setSpawnPerTick(int spawnPerTick) {
        this.spawnPerTick = spawnPerTick;
    }

    private void spawn(GameWorld world) {
        Class<Sun> suns = world.getEntities().get((Entity)((Object)Sun.class));
        Iterator i$ = suns.iterator();
        while (i$.hasNext()) {
            Sun sun = (Sun)i$.next();
            for (int i = 0; i < this.spawnPerTick; ++i) {
                double angle = (double)(world.getRandom().nextFloat() * 2.0f) * Math.PI;
                Vec2 dir = new Vec2((float)Math.cos(angle), (float)Math.sin(angle));
                sun.shoot(world, dir, this.sunShotSpeed);
            }
        }
    }

    private void spawnSmallFlares(GameWorld world) {
        Class<Sun> suns = world.getEntities().get((Entity)((Object)Sun.class));
        Iterator i$ = suns.iterator();
        while (i$.hasNext()) {
            Sun sun = (Sun)i$.next();
            double angle = (double)(world.getRandom().nextFloat() * 2.0f) * Math.PI;
            Vec2 dir = new Vec2((float)Math.cos(angle), (float)Math.sin(angle));
            sun.shoot(world, dir, 3.5f);
        }
    }

    public void setSunShotSpeed(float sunShotSpeed) {
        this.sunShotSpeed = sunShotSpeed;
    }
}

