/*
 * Decompiled with CFR 0.152.
 */
package game.entities;

import game.engine.loader.EntityDescriptor;
import game.entities.Entity;
import game.entities.PlayerPlanet;
import game.world.GameWorld;
import org.newdawn.slick.Animation;
import org.newdawn.slick.Color;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.geom.Rectangle;

public class HudEntity
extends Entity {
    private Rectangle rectangle;
    private Color lineColor;
    private Color fillColor;
    private Color textColor;
    private int padding;
    private Animation icon;

    public HudEntity(EntityDescriptor descriptor) {
        super(descriptor);
        this.rectangle = new Rectangle(this.propertyMap.getFloat("x"), this.propertyMap.getFloat("y"), this.propertyMap.getFloat("width"), this.propertyMap.getFloat("height"));
        float[] lineArray = this.propertyMap.getFloatArray("linecolor", 1.0f, 1.0f, 1.0f, 1.0f);
        float[] fillArray = this.propertyMap.getFloatArray("fillcolor", 1.0f, 1.0f, 1.0f, 1.0f);
        float[] textArray = this.propertyMap.getFloatArray("textcolor", 0.0f, 0.0f, 0.0f, 1.0f);
        this.lineColor = new Color(lineArray[0], lineArray[1], lineArray[2], lineArray[3]);
        this.fillColor = new Color(fillArray[0], fillArray[1], fillArray[2], fillArray[3]);
        this.textColor = new Color(textArray[0], textArray[1], textArray[2], textArray[3]);
        this.padding = this.propertyMap.getInt("padding", 10);
        this.icon = this.animations.get("icon", null);
    }

    public boolean preRender(Graphics g, GameWorld world, GameContainer container) {
        world.getCamera().applyInverseTransform(g, container);
        return true;
    }

    public void render(Graphics g, GameWorld world, GameContainer container) {
        g.setColor(this.fillColor);
        g.fill(this.rectangle);
        g.setColor(this.lineColor);
        g.draw(this.rectangle);
        float xright = this.rectangle.getMinX() + (float)this.padding;
        if (this.icon != null) {
            float scale = (this.rectangle.getHeight() - 2.0f * (float)this.padding) / (float)this.icon.getHeight();
            this.icon.draw(this.rectangle.getMinX() + (float)this.padding, this.rectangle.getMinY() + (float)this.padding, scale * (float)this.icon.getWidth(), scale * (float)this.icon.getHeight());
            xright += scale * (float)this.icon.getWidth() + (float)this.padding;
        }
        float ytop = this.rectangle.getMinY() + (float)this.padding;
        PlayerPlanet player = world.getEntities().getOne(PlayerPlanet.class);
        float healthPercentage = player.getHealthPercentage();
        String string = "Health: " + (int)Math.ceil(healthPercentage) + "\n" + "Moons: " + player.getOrbiters().size();
        g.setColor(this.textColor);
        g.drawString(string, xright, ytop);
    }

    public void postRender(Graphics g, GameWorld world, GameContainer container) {
        world.getCamera().applyTransform(g, container);
    }
}

