/*
 * Decompiled with CFR 0.152.
 */
package game.entities;

import game.engine.BoundingBox;
import game.engine.loader.EntityDescriptor;
import game.entities.Meteorite;
import game.entities.Moon;
import game.entities.ParticleProvider;
import game.world.GameWorld;
import org.jbox2d.common.Vec2;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.geom.Vector2f;
import org.newdawn.slick.particles.ConfigurableEmitter;
import org.newdawn.slick.particles.ParticleSystem;

public class MeteoriteBig
extends Meteorite {
    private ParticleSystem lineParticles = new ParticleSystem("/assets/graphics/default_particle.png", 40);
    private ConfigurableEmitter lineEmitter;
    private int bufferedTime;

    public MeteoriteBig(EntityDescriptor descriptor) {
        super(descriptor);
        this.lineEmitter = descriptor.particleEmitters.get("short_line_emitter").duplicate();
        this.lineParticles.addEmitter(this.lineEmitter);
        this.transformedRendering = false;
    }

    public void update(int dt, GameWorld world, GameContainer container) {
        super.update(dt, world, container);
        if (this.body != null) {
            Vec2 bodyPos = this.body.getWorldCenter().mul(100.0f);
            this.lineEmitter.setPosition(bodyPos.x, bodyPos.y);
            BoundingBox sb = world.getCamera().getScreenBounds();
            Vector2f sp = world.getCamera().getScreenPos();
            if (sb.intersects(sp, this.getBounds(), this.getPos())) {
                this.lineParticles.update(dt + this.bufferedTime);
                this.bufferedTime = 0;
            } else {
                this.bufferedTime += dt;
            }
        }
    }

    public void render(Graphics g, GameWorld world, GameContainer container) {
        this.lineParticles.render();
        this.applyTransform(g);
        super.render(g, world, container);
        this.applyInverseTransform(g);
    }

    public void laserDamage(GameWorld world, Moon moon, float x, float y) {
        world.getEntities().getOne(ParticleProvider.class).spawnEmitter("suncollision_emitter", new Vector2f(x * 100.0f, y * 100.0f), new Vector2f(0.0f, 0.0f));
        world.getEntities().remove(this);
        world.collisionSound(0.0f);
    }
}

