/*
 * Decompiled with CFR 0.152.
 */
package game.entities;

import game.engine.loader.EntityDescriptor;
import game.entities.ArenaBounds;
import game.entities.Entity;
import game.world.GameWorld;
import org.jbox2d.common.Vec2;
import org.newdawn.slick.GameContainer;

public class MeteoriteSpawner
extends Entity {
    private int tick;
    private int tickStep;
    private int spawnPerTick;
    private int spawnForce;

    public MeteoriteSpawner(EntityDescriptor descriptor) {
        super(descriptor);
        this.setTickStep(2500);
        this.setSpawnPerTick(30);
        this.spawnForce = 40;
    }

    public void update(int dt, GameWorld world, GameContainer container) {
        super.update(dt, world, container);
        this.tick += dt;
        if (this.tick > this.tickStep) {
            this.tick = 0;
            this.spawn(world);
        }
    }

    public void setTickStep(int tickStep) {
        this.tickStep = tickStep;
    }

    public void setSpawnPerTick(int spawnPerTick) {
        this.spawnPerTick = spawnPerTick;
    }

    private void spawn(GameWorld world) {
        float arenaRadius = world.getEntities().getOne(ArenaBounds.class).getArenaRadius() + 20.0f;
        float meteorDirectorRadius = arenaRadius * 0.5f;
        Vec2 spawnPosition = new Vec2();
        Vec2 meteorDirector = new Vec2();
        for (int i = 0; i < this.spawnPerTick; ++i) {
            spawnPosition.x = world.getRandom().nextFloat() * 2.0f - 1.0f;
            spawnPosition.y = world.getRandom().nextFloat() * 2.0f - 1.0f;
            spawnPosition.normalize();
            spawnPosition = spawnPosition.mul(arenaRadius);
            meteorDirector.x = world.getRandom().nextFloat() * 2.0f - 1.0f;
            meteorDirector.y = world.getRandom().nextFloat() * 2.0f - 1.0f;
            meteorDirector.normalize();
            meteorDirector = meteorDirector.mul(meteorDirectorRadius);
            Vec2 forceDir = new Vec2(meteorDirector.x - spawnPosition.x, meteorDirector.y - spawnPosition.y);
            forceDir.normalize();
            forceDir = forceDir.mul((world.getRandom().nextFloat() + 0.3f) * (float)this.spawnForce);
            Entity meteorite = world.getLoader().create(world.getRandom().nextInt(3) == 0 ? "meteoriteBigFrozen" : "meteoriteBig");
            meteorite.setPos(spawnPosition.x * 100.0f, spawnPosition.y * 100.0f);
            world.getEntities().add(meteorite);
            meteorite.getBody().setTransform(spawnPosition, meteorite.getBody().getAngle());
            meteorite.body.applyTorque(world.getRandom().nextFloat() - 0.5f);
            meteorite.body.applyForce(forceDir, spawnPosition);
        }
    }
}

