/*
 * Decompiled with CFR 0.152.
 */
package game.entities;

import game.engine.BoundingBox;
import game.engine.loader.EntityDescriptor;
import game.entities.PhysicsEntity;
import game.entities.PlayerPlanet;
import game.world.GameWorld;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.jbox2d.callbacks.RayCastCallback;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.Fixture;
import org.newdawn.slick.Color;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.geom.Vector2f;

public class Moon
extends PhysicsEntity {
    private static final float MAX_ORBIT_DISTANCE = 3.0f;
    private static final float MAX_VELOCITY_DIFFERENCE = 1.0f;
    private static final float MIN_ORBIT_DISTANCE = 1.0f;
    private static final float DELTA_ORBIT_DISTANCE = 0.3f;
    private static final int SHOT_DURATION = 50;
    private static final int COOLDOWN_MAX = 200;
    private static final int COOLDOWN_MIN = 100;
    private static final float MAX_SHOT_DISTANCE = 5.0f;
    private int cooldown = 0;
    private int shotTime = 0;
    private Vec2 shot;

    public Moon(EntityDescriptor descriptor) {
        super(descriptor);
        this.transformedRendering = false;
        this.shot = null;
    }

    public void update(int dt, final GameWorld world, GameContainer container) {
        super.update(dt, world, container);
        if (this.isInOrbit()) {
            PlayerPlanet player = world.getEntities().getOne(PlayerPlanet.class);
            Body pb = player.getBody();
            if (pb != null && this.getOrbitTarget().equals(player)) {
                this.cooldown -= dt;
                this.shotTime -= dt;
                if (this.cooldown <= 0 && container.getInput().isMouseButtonDown(0) && this.getBody() != null) {
                    Vec2 origin;
                    float y;
                    Vector2f sp;
                    int mx = container.getInput().getMouseX();
                    int my = container.getInput().getMouseY();
                    BoundingBox sb = world.getCamera().getScreenBounds();
                    float x = sb.getMinX(sp = world.getCamera().getScreenPos()) + (float)mx / (float)container.getWidth() * sb.getWidth();
                    final Vec2 hitPos = new Vec2(x / 100.0f, (y = sb.getMinY(sp) + (float)my / (float)container.getHeight() * sb.getHeight()) / 100.0f);
                    Vec2 delta = hitPos.sub(origin = this.getBody().getPosition().clone());
                    if (delta.length() > 5.0f) {
                        delta.mulLocal(5.0f / delta.length());
                        hitPos.set(origin);
                        hitPos.addLocal(delta);
                    }
                    this.cooldown = world.getRandom().nextInt(100) + 100 + 50;
                    this.shotTime = 50;
                    Vector2f v = new Vector2f(hitPos.x, hitPos.y);
                    v.add(world.getRandom().nextFloat() * 2.0f - 1.0f);
                    hitPos.x = v.x;
                    hitPos.y = v.y;
                    world.getPhysicsWorld().raycast(new RayCastCallback(){

                        public float reportFixture(Fixture f, Vec2 p, Vec2 n, float fract) {
                            Object o = f.getBody().getUserData();
                            if (o.equals(Moon.this)) {
                                return -1.0f;
                            }
                            hitPos.set(p);
                            ((PhysicsEntity)o).laserDamage(world, Moon.this, p.x, p.y);
                            return fract;
                        }
                    }, this.getBody().getPosition(), hitPos.clone());
                    this.playAudio("laser", 0.0f);
                    this.shot = hitPos;
                }
            }
        } else {
            PlayerPlanet player = world.getEntities().getOne(PlayerPlanet.class);
            Body pb = player.getBody();
            Body pa = this.getBody();
            if (pb != null && pa != null) {
                Vec2 a = pa.getPosition();
                Vec2 b = pb.getPosition();
                Vec2 va = pa.getLinearVelocity();
                Vec2 vb = pb.getLinearVelocity();
                if (a.sub(b).length() < 3.0f && Math.abs(va.length() - vb.length()) < 1.0f) {
                    va.normalize();
                    vb.normalize();
                    if (Math.abs(Vec2.dot(va, vb)) > 0.8f) {
                        ArrayList<PhysicsEntity> orbiters = new ArrayList<PhysicsEntity>(player.getOrbiters());
                        Collections.sort(orbiters, new DistanceComparator());
                        float distance = Float.MAX_VALUE;
                        if (orbiters.isEmpty()) {
                            distance = 1.0f;
                        } else {
                            for (int i = 0; i < orbiters.size(); ++i) {
                                float first = orbiters.get(i).getOrbitDistance();
                                if (i == orbiters.size() - 1) {
                                    distance = first + 0.3f;
                                    continue;
                                }
                                float second = orbiters.get(i + 1).getOrbitDistance();
                                if (!(second - first >= 0.6f)) continue;
                                distance = first + 0.3f;
                            }
                        }
                        if (distance <= 3.0f) {
                            this.createOrbit(world, player, distance, 2.0f + 0.5f * distance);
                        }
                    }
                }
            }
        }
    }

    public void render(Graphics g, GameWorld world, GameContainer container) {
        this.applyTransform(g);
        super.render(g, world, container);
        if (!this.isInOrbit()) {
            BoundingBox b = this.getBounds();
            float x1 = b.getMinX(0.0f, 0.0f);
            float y1 = b.getMinY(0.0f, 0.0f);
            float x2 = b.getMaxX(0.0f, 0.0f);
            float y2 = b.getMaxY(0.0f, 0.0f);
            g.setColor(Color.green);
            g.drawLine(x1, y1, x1 + 5.0f, y1);
            g.drawLine(x1, y1, x1, y1 + 5.0f);
            g.drawLine(x2, y2, x2 - 5.0f, y2);
            g.drawLine(x2, y2, x2, y2 - 5.0f);
            g.drawLine(x1, y2, x1 + 5.0f, y2);
            g.drawLine(x1, y2, x1, y2 - 5.0f);
            g.drawLine(x2, y1, x2 - 5.0f, y1);
            g.drawLine(x2, y1, x2, y1 + 5.0f);
        }
        this.applyInverseTransform(g);
        if (this.shotTime > 0) {
            g.setColor(Color.red);
            g.drawLine(this.getPos().x, this.getPos().y, this.shot.x * 100.0f, this.shot.y * 100.0f);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DistanceComparator
    implements Comparator<PhysicsEntity> {
        private DistanceComparator() {
        }

        @Override
        public int compare(PhysicsEntity a, PhysicsEntity b) {
            return Float.valueOf(a.getOrbitDistance()).compareTo(Float.valueOf(b.getOrbitDistance()));
        }
    }
}

