/*
 * Decompiled with CFR 0.152.
 */
package game.entities;

import game.engine.loader.EntityDescriptor;
import game.entities.ArenaBounds;
import game.entities.Entity;
import game.world.GameWorld;
import org.jbox2d.common.Vec2;
import org.newdawn.slick.GameContainer;

public class MoonSpawner
extends Entity {
    private int tick;
    private int tickStep;
    private int spawnPerTick;
    private int spawnForce;

    public MoonSpawner(EntityDescriptor descriptor) {
        super(descriptor);
        this.setTickStep(2500);
        this.setSpawnPerTick(5);
        this.spawnForce = 5;
    }

    public void update(int dt, GameWorld world, GameContainer container) {
        super.update(dt, world, container);
        this.tick += dt;
        if (this.tick > this.tickStep) {
            this.tick = 0;
            this.spawn(world);
        }
    }

    public void setTickStep(int tickStep) {
        this.tickStep = tickStep;
    }

    public void setSpawnPerTick(int spawnPerTick) {
        this.spawnPerTick = spawnPerTick;
    }

    private void spawn(GameWorld world) {
        float arenaRadius = world.getEntities().getOne(ArenaBounds.class).getArenaRadius() + 20.0f;
        float meteorDirectorRadius = arenaRadius * 0.5f;
        Vec2 spawnPosition = new Vec2();
        Vec2 moonDirection = new Vec2();
        for (int i = 0; i < this.spawnPerTick; ++i) {
            spawnPosition.x = world.getRandom().nextFloat() * 2.0f - 1.0f;
            spawnPosition.y = world.getRandom().nextFloat() * 2.0f - 1.0f;
            spawnPosition.normalize();
            spawnPosition = spawnPosition.mul(arenaRadius);
            moonDirection.x = world.getRandom().nextFloat() * 2.0f - 1.0f;
            moonDirection.y = world.getRandom().nextFloat() * 2.0f - 1.0f;
            moonDirection.normalize();
            moonDirection = moonDirection.mul(meteorDirectorRadius);
            Vec2 forceDir = new Vec2(moonDirection.x - spawnPosition.x, moonDirection.y - spawnPosition.y);
            forceDir.normalize();
            forceDir = forceDir.mul((world.getRandom().nextFloat() + 0.5f) * (float)this.spawnForce);
            Entity moon = world.getLoader().create("moon");
            moon.setPos(spawnPosition.x * 100.0f, spawnPosition.y * 100.0f);
            world.getEntities().add(moon);
            moon.getBody().setTransform(spawnPosition, moon.getBody().getAngle());
            moon.body.applyTorque(world.getRandom().nextFloat() - 0.5f);
            moon.body.applyForce(forceDir, spawnPosition);
        }
    }
}

