/*
 * Decompiled with CFR 0.152.
 */
package game.entities;

import game.engine.loader.EntityDescriptor;
import game.entities.Entity;
import game.world.GameWorld;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.geom.Vector2f;
import org.newdawn.slick.particles.ConfigurableEmitter;
import org.newdawn.slick.particles.ParticleSystem;

public class ParticleProvider
extends Entity {
    private ParticleSystem system = new ParticleSystem("/assets/graphics/default_particle.png", 100);

    public ParticleProvider(EntityDescriptor descriptor) {
        super(descriptor);
        this.system.setRemoveCompletedEmitters(true);
    }

    public ParticleSystem getSystem() {
        return this.system;
    }

    public void update(int dt, GameWorld world, GameContainer container) {
        super.update(dt, world, container);
        this.system.update(dt);
    }

    public boolean preRender(Graphics g, GameWorld world, GameContainer container) {
        return true;
    }

    public void render(Graphics g, GameWorld world, GameContainer container) {
        this.system.render();
    }

    public void postRender(Graphics g, GameWorld world, GameContainer container) {
    }

    public ConfigurableEmitter spawnEmitter(String emitterName, Vector2f pos, Vector2f dir) {
        ConfigurableEmitter emitter = ((ConfigurableEmitter)this.emitters.get(emitterName)).duplicate();
        emitter.setPosition(pos.x, pos.y);
        ConfigurableEmitter.SimpleValue val = (ConfigurableEmitter.SimpleValue)emitter.angularOffset;
        val.setValue((float)dir.getTheta());
        this.system.addEmitter(emitter);
        return emitter;
    }
}

